/*
 * Decompiled with CFR 0.152.
 */
package com.fabriziopolo.timecraft.world.map.alpha;

import com.fabriziopolo.textcraft.nlg.Prepositions;
import com.fabriziopolo.textcraft.objects.EmptyNoun;
import com.fabriziopolo.textcraft.player.Player;
import com.fabriziopolo.textcraft.simulation.Noun;
import com.fabriziopolo.textcraft.simulation.Simulation;
import com.fabriziopolo.textcraft.states.scenery.BandedScenery;
import com.fabriziopolo.textcraft.states.scenery.RectLimitedScenery;
import com.fabriziopolo.textcraft.states.scenery.Scenery;
import com.fabriziopolo.textcraft.states.scenery.SceneryState;
import com.fabriziopolo.textcraft.states.scenery.VisualScenery;
import com.fabriziopolo.timecraft.world.dsl.beach.Rooms;
import com.fabriziopolo.timecraft.world.dsl.beach.Sceneries;
import com.fabriziopolo.timecraft.world.map.rendering.MapPopulator;
import com.fabriziopolo.timecraft.world.map.rendering.MapRoomCreator;
import com.fabriziopolo.timecraft.world.map.rendering.PaintedMapPopulator;
import com.fabriziopolo.timecraft.world.map.rendering.RoomPopulator;
import java.util.List;

public class AlphaMapPopulator
extends PaintedMapPopulator
implements MapPopulator {
    private final Player player;
    private final int xStart;
    private final int yStart;

    public AlphaMapPopulator(Simulation simulation, Player player, int xLength, int yLength, int xStart, int yStart) {
        super(simulation, xLength, yLength);
        this.player = player;
        this.xStart = xStart;
        this.yStart = yStart;
        this.paintRoomCreatorMap();
        this.paintRoomPopulatorMap();
        this.paintSceneryPopulatorMap();
    }

    @Override
    public void finish() {
        super.finish();
        this.dsl.beach().story().createTimedEvents(this.player, this);
        this.createDistantScenery();
    }

    private void paintRoomCreatorMap() {
        this.paintWithPredicate((x, y) -> true, this::createOceanRoom);
        this.paintLittleIsland();
        this.paintMainland();
    }

    private void paintLittleIsland() {
        Rooms rooms = this.dsl.beach().rooms();
        MapRoomCreator ___ = (x, y) -> rooms.deepWater();
        MapRoomCreator __ = (x, y) -> rooms.shallowWater();
        MapRoomCreator IIW = (x, y) -> rooms.shallowWaterWithReeds("west");
        MapRoomCreator IIE = (x, y) -> rooms.shallowWaterWithReeds("east");
        MapRoomCreator _f_ = (x, y) -> rooms.shallowWaterWithFish();
        MapRoomCreator b = (x, y) -> rooms.whiteBeach();
        MapRoomCreator bp = (x, y) -> rooms.whiteBeachWithPebbles();
        MapRoomCreator iii = (x, y) -> rooms.whiteBeachWithGrass();
        MapRoomCreator _TT = this::createIslandTreeRoom;
        MapRoomCreator _oT = this::createIslandCenterRoom;
        MapRoomCreator NW = (x, y) -> rooms.whiteBeachCorner("northwest");
        MapRoomCreator NE = (x, y) -> rooms.whiteBeachCorner("northeast");
        MapRoomCreator SE = (x, y) -> rooms.whiteBeachCorner("southeast");
        MapRoomCreator SW = (x, y) -> rooms.whiteBeachCorner("southwest");
        MapRoomCreator END = this::createEndRoom;
        MapRoomCreator[][] map = new MapRoomCreator[][]{{___, ___, ___, ___, ___, ___, ___, ___, ___}, {___, __, __, _f_, __, __, _f_, __, ___}, {___, __, NW, b, b, b, NE, __, ___}, {___, __, b, iii, _oT, _TT, bp, __, ___}, {___, __, SW, b, b, bp, SE, _f_, ___}, {___, __, __, IIW, IIE, __, __, __, ___}, {___, ___, ___, ___, ___, ___, ___, ___, ___}};
        int mapWidth = map[0].length;
        int mapHeight = map.length;
        int relStartX = this.xStart - 3;
        int relStartY = this.yStart - 2;
        for (int x2 = 0; x2 < mapWidth; ++x2) {
            for (int y2 = 0; y2 < mapHeight; ++y2) {
                this.roomCreatorMap[x2 + relStartX][y2 + relStartY] = map[y2][x2];
            }
        }
    }

    private int getLittleIslandCenterX() {
        return this.xStart + 1;
    }

    private int getLittleIslandCenterY() {
        return this.yStart + 1;
    }

    private Noun createOceanRoom(int x, int y) {
        return this.dsl.beach().rooms().deepWater();
    }

    private Noun createIslandCenterRoom(int x, int y) {
        return this.dsl.beach().rooms().islandCenterRoom();
    }

    private Noun createIslandTreeRoom(int x, int y) {
        return this.dsl.beach().rooms().islandTreeRoom();
    }

    private void paintMainland() {
        MapRoomCreator ___ = (x, y) -> this.dsl.beach().rooms().deepWater();
        MapRoomCreator __ = (x, y) -> this.dsl.beach().rooms().shallowWater();
        MapRoomCreator _f_ = (x, y) -> this.dsl.beach().rooms().shallowWaterWithFish();
        MapRoomCreator END = this::createEndRoom;
        MapRoomCreator b = (x, y) -> this.dsl.beach().rooms().whiteBeach();
        MapRoomCreator bp = (x, y) -> this.dsl.beach().rooms().whiteBeachWithPebbles();
        MapRoomCreator iii = (x, y) -> this.dsl.beach().rooms().whiteBeachWithGrass();
        MapRoomCreator _TT = this::createIslandTreeRoom;
        MapRoomCreator _oT = this::createIslandCenterRoom;
        int xCursor = this.xLength - 1;
        this.paintVerticalLine(xCursor, iii);
        this.paintVerticalLine(--xCursor, b);
        this.paintVerticalLine(--xCursor, END);
        this.paintVerticalLine(--xCursor, __);
        --xCursor;
    }

    private Noun createEndRoom(int x, int y) {
        return this.dsl.beach().rooms().gameEndRoom();
    }

    private void paintRoomPopulatorMap() {
        int X = this.getLittleIslandCenterX();
        int Y = this.getLittleIslandCenterY();
        List<Noun> trilobites = this.dsl.beach().story().createTrilobites(3);
        Object ___ = null;
        Object __ = null;
        Object III = null;
        Object _f_ = null;
        Object b = null;
        Object bp = null;
        RoomPopulator iii = this.populate(this.dsl.beach().plants().treeLog("palm"));
        RoomPopulator PW0 = this.delayedPopulate(() -> this.dsl.beach().resources().driftwood(), 0, 0);
        RoomPopulator PF0 = this.populate(this.dsl.beach().resources().flint()).and(this.delayedPopulate(trilobites.get(0), 3, 1));
        RoomPopulator PG0 = this.populate(this.dsl.beach().tools().glassLense());
        RoomPopulator S = this.populate(this.dsl.beach().resources().driftwood());
        Noun junglePlantLeaf = this.dsl.beach().plants().junglePlantLeaf();
        this.put(this.dsl.beach().resources().rainWater(), Prepositions.in, Prepositions.under, junglePlantLeaf);
        RoomPopulator TT = this.populate(junglePlantLeaf);
        RoomPopulator _oT = this.populate(this.dsl.tools().stone());
        RoomPopulator PW2 = this.delayedPopulate(this.dsl.beach().resources().driftwood(), 2, 0);
        RoomPopulator PC3 = this.delayedPopulate(this.dsl.tools().can(), 3, 0);
        RoomPopulator PW4 = this.delayedPopulate(this.dsl.beach().resources().driftwood(), 4, 0);
        RoomPopulator G = PG0.and(this.delayedPopulate(trilobites.get(2), 3, 1));
        RoomPopulator BG = this.populate(this.dsl.beach().resources().beachGlass("blue"));
        Noun startBottle = this.dsl.tools().plasticBottle();
        this.put(this.dsl.beach().resources().nonObviousSeawater(), Prepositions.in, startBottle);
        RoomPopulator PB0 = this.populate(startBottle);
        RoomPopulator M = this.delayedPopulate(() -> this.dsl.beach().story().mushroom(), 4, 0);
        RoomPopulator GM = G.and(M);
        RoomPopulator BGM = BG.and(M);
        RoomPopulator XXX = this.delayedPopulate(trilobites.get(1), 3, 1);
        RoomPopulator[][] map = new RoomPopulator[][]{{___, ___, ___, ___, ___, ___, ___, ___, ___}, {___, __, __, _f_, __, __, _f_, __, ___}, {___, __, BGM, S, M, XXX, b, __, ___}, {___, __, b, iii, _oT, TT, PF0, __, ___}, {___, __, b, M, b, GM, PW0, _f_, ___}, {___, __, __, PB0, __, __, __, __, ___}, {___, ___, ___, ___, ___, ___, ___, ___, ___}};
        int mapWidth = map[0].length;
        int mapHeight = map.length;
        int relStartX = this.xStart - 3;
        int relStartY = this.yStart - 2;
        for (int x = 0; x < mapWidth; ++x) {
            for (int y = 0; y < mapHeight; ++y) {
                this.roomPopulatorMap[x + relStartX][y + relStartY] = map[y][x];
            }
        }
    }

    private RoomPopulator populateAllTheThings() {
        return new RoomPopulator(){

            @Override
            public void populate(Noun room, Integer x, Integer y) {
                AlphaMapPopulator.this.putInRoom(AlphaMapPopulator.this.dsl.tools().knife(), room);
                AlphaMapPopulator.this.putInRoom(AlphaMapPopulator.this.dsl.tools().can(), room);
                AlphaMapPopulator.this.putInRoom(AlphaMapPopulator.this.dsl.tools().plasticBottle(), room);
                AlphaMapPopulator.this.putInRoom(AlphaMapPopulator.this.dsl.tools().glassLense(), room);
                AlphaMapPopulator.this.putInRoom(AlphaMapPopulator.this.dsl.tools().stone(), room);
                AlphaMapPopulator.this.putInRoom(AlphaMapPopulator.this.dsl.beach().resources().driftwood(), room);
                AlphaMapPopulator.this.putInRoom(AlphaMapPopulator.this.dsl.beach().resources().driftwood(), room);
                AlphaMapPopulator.this.putInRoom(AlphaMapPopulator.this.dsl.beach().resources().driftwood(), room);
                AlphaMapPopulator.this.putInRoom(AlphaMapPopulator.this.dsl.beach().resources().beachGlass("blue"), room);
                AlphaMapPopulator.this.putInRoom(AlphaMapPopulator.this.dsl.beach().resources().tangledFishingLine(), room);
                AlphaMapPopulator.this.putInRoom(AlphaMapPopulator.this.dsl.beach().resources().flint(), room);
                AlphaMapPopulator.this.putInRoom(AlphaMapPopulator.this.dsl.beach().resources().plasticBag("brown"), room);
                AlphaMapPopulator.this.putInRoom(AlphaMapPopulator.this.dsl.beach().resources().chunkOfRottenChipboard(), room);
                AlphaMapPopulator.this.putInRoom(AlphaMapPopulator.this.dsl.beach().resources().chunkOfRottenChipboard(), room);
                AlphaMapPopulator.this.putInRoom(AlphaMapPopulator.this.dsl.beach().plants().treeLog("palm tree"), room);
                AlphaMapPopulator.this.putInRoom(AlphaMapPopulator.this.dsl.beach().plants().poisonBerry(), room);
                AlphaMapPopulator.this.putInRoom(AlphaMapPopulator.this.dsl.beach().plants().junglePlant(), room);
                AlphaMapPopulator.this.putInRoom(AlphaMapPopulator.this.dsl.beach().plants().coconut(), room);
                AlphaMapPopulator.this.putInRoom(AlphaMapPopulator.this.dsl.beach().plants().reeds(), room);
                AlphaMapPopulator.this.putInRoom(AlphaMapPopulator.this.dsl.beach().plants().goldenReeds(), room);
                AlphaMapPopulator.this.putInRoom(AlphaMapPopulator.this.dsl.beach().plants().duneGrass(), room);
                AlphaMapPopulator.this.putInRoom(AlphaMapPopulator.this.dsl.beach().plants().duneGrass(), room);
                AlphaMapPopulator.this.putInRoom(AlphaMapPopulator.this.dsl.beach().foods().ripeRedBanana(), room);
                AlphaMapPopulator.this.putInRoom(AlphaMapPopulator.this.dsl.beach().foods().blueMussel(), room);
            }
        };
    }

    private void paintSceneryPopulatorMap() {
        Sceneries sceneries = this.dsl.beach().sceneries();
        Object ___ = null;
        Object __ = null;
        Object o = null;
        Scenery northEastBeach = sceneries.beachContinues("north", "east", 3.0);
        Scenery northWestBeach = sceneries.beachContinues("north", "west", 3.0);
        Scenery southEastBeach = sceneries.beachContinues("south", "east", 3.0);
        Scenery southWestBeach = sceneries.beachContinues("south", "west", 3.0);
        Scenery eastNorthBeach = sceneries.beachContinues("east", "north", 5.0);
        Scenery eastsouthBeach = sceneries.beachContinues("east", "south", 5.0);
        Scenery westNorthBeach = sceneries.beachContinues("west", "north", 5.0);
        Scenery westsouthBeach = sceneries.beachContinues("west", "south", 5.0);
        RoomPopulator SE = this.attachScenery(southWestBeach.or(eastNorthBeach));
        RoomPopulator NE = this.attachScenery(eastsouthBeach.or(northWestBeach));
        RoomPopulator NW = this.attachScenery(northEastBeach.or(westsouthBeach));
        RoomPopulator SW = this.attachScenery(southEastBeach.or(westNorthBeach));
        RoomPopulator AI = this.attachScenery(new RectLimitedScenery(3.0, 2.0, sceneries.islandCenter()).or(new RectLimitedScenery(8.0, 7.0, 3.0, 2.0, sceneries.islandFromNear())).or(new RectLimitedScenery(20.0, 20.0, 8.0, 7.0, sceneries.islandFromFar())));
        RoomPopulator[][] map = new RoomPopulator[][]{{___, ___, ___, ___, ___, ___, ___, ___, ___}, {___, __, __, __, __, __, __, __, ___}, {___, __, NW, o, o, o, NE, __, ___}, {___, __, o, o, AI, o, o, __, ___}, {___, __, SW, o, o, o, SE, __, ___}, {___, __, __, o, o, __, __, __, ___}, {___, ___, ___, ___, ___, ___, ___, ___, ___}};
        int mapWidth = map[0].length;
        int mapHeight = map.length;
        int relStartX = this.xStart - 3;
        int relStartY = this.yStart - 2;
        for (int x = 0; x < mapWidth; ++x) {
            for (int y = 0; y < mapHeight; ++y) {
                this.sceneryPopulatorMap[x + relStartX][y + relStartY] = map[y][x];
            }
        }
    }

    private RoomPopulator attachScenery(final Scenery scenery) {
        return new RoomPopulator(){

            @Override
            public void populate(Noun room, Integer x, Integer y) {
                SceneryState.requestPut(room, scenery, AlphaMapPopulator.this.simulation);
            }
        };
    }

    private void createDistantScenery() {
        Sceneries sceneries = this.dsl.beach().sceneries();
        EmptyNoun mainlandSpot = new EmptyNoun();
        this.setCoordinates(mainlandSpot, (double)this.xLength - 1.0 - 2.0, this.yLength / 2);
        this.putScenery(mainlandSpot, new BandedScenery(2.0, 7.0, "east", sceneries.mainlandFromNear()).or(new BandedScenery(7.0, 1000.0, "east", sceneries.mainlandFromAfar())));
        EmptyNoun westernSkySpot = new EmptyNoun();
        this.setCoordinates(westernSkySpot, 0.0, this.yLength / 2);
        this.putScenery(westernSkySpot, new VisualScenery(sceneries.weasternOceanAndSky()));
    }
}

