/*
 * Decompiled with CFR 0.152.
 */
package com.fabriziopolo.timecraft.world.dsl.plains;

import com.fabriziopolo.textcraft.events.notification.PlayerNotificationEvent;
import com.fabriziopolo.textcraft.nlg.SimpleNounAutoBuilder;
import com.fabriziopolo.textcraft.objects.SimpleNoun;
import com.fabriziopolo.textcraft.player.Player;
import com.fabriziopolo.textcraft.simulation.Frame;
import com.fabriziopolo.textcraft.simulation.Noun;
import com.fabriziopolo.textcraft.simulation.Simulation;
import com.fabriziopolo.textcraft.states.characterbio.CharacterBioEffect;
import com.fabriziopolo.textcraft.states.characterbio.health.HealthState;
import com.fabriziopolo.textcraft.states.position.PositionStateBuilder;
import com.fabriziopolo.textcraft.states.takeable.TakeHandler;
import com.fabriziopolo.timecraft.capabilities.ResourceCapabilities;
import com.fabriziopolo.timecraft.world.constants.Encumbrances;
import com.fabriziopolo.timecraft.world.dsl.Dsl;
import com.fabriziopolo.timecraft.world.dsl.plains.Plains;
import java.util.ArrayList;
import java.util.List;

public class Animals
extends Plains {
    public Animals(Simulation simulation) {
        super(simulation);
    }

    public Noun rabbit() {
        SimpleNoun obj = new SimpleNounAutoBuilder().setDescription("This rabbit is as adorable as it is delicious.", "a rabbit", "rabbits", new String[0]).build();
        this.setHealth(obj, 1.0);
        this.setTakeHandler(obj, new TakeHandler(){

            @Override
            public List<Noun> willProduce(Player player, Noun nounToTake, Noun tool, Simulation simulation, PositionStateBuilder partialState) {
                Animals animals = new Dsl(simulation).plains().animals();
                ArrayList<Noun> spoils = new ArrayList<Noun>();
                spoils.add(animals.rabbitMeat());
                spoils.add(animals.rabbitPelt());
                return spoils;
            }

            @Override
            public boolean isProducible(Player player, Noun nounToTake, Noun tool, Frame frame) {
                if (HealthState.get(frame).isAlive(nounToTake)) {
                    return false;
                }
                return TakeHandler.super.isProducible(player, nounToTake, tool, frame);
            }

            @Override
            public void onNotProducible(Player player, Noun nounToTake, Noun tool, Simulation simulation, PositionStateBuilder partialState) {
                PlayerNotificationEvent.post((Noun)player, simulation, "The rabbit effortlessly hops away from your clumsy lunge.");
            }
        });
        this.setEncumbrance(obj, Encumbrances.HAND_SIZED);
        return obj;
    }

    public Noun rabbitMeat() {
        SimpleNoun obj = SimpleNoun.auto("A skinned and dressed rabbit.", "rabbit meat", "meat", new String[0]);
        this.makeEdible((Noun)obj, "You scarf down a pile of greasy, gamey, dark meat.  Delicious.", CharacterBioEffect.builder().addFood(1.0).build());
        this.setEncumbrance(obj, Encumbrances.HAND_SIZED);
        return obj;
    }

    public Noun rabbitPelt() {
        SimpleNoun obj = SimpleNoun.auto("The soft pelt of a tasty rabbit.", "a rabbit pelt", "pelts", new String[0]);
        this.setEncumbrance(obj, Encumbrances.HALF_HAND_SIZED);
        this.addResourceCapability(obj, ResourceCapabilities.BRA_CUP_MATERIAL);
        this.addResourceCapability(obj, ResourceCapabilities.SMALL_GAME_FUR_MATERIAL);
        return obj;
    }
}

