/*
 * Decompiled with CFR 0.152.
 */
package com.fabriziopolo.timecraft.world.dsl.jungle;

import com.fabriziopolo.textcraft.nlg.Nlg;
import com.fabriziopolo.textcraft.nlg.Prepositions;
import com.fabriziopolo.textcraft.objects.SimpleNoun;
import com.fabriziopolo.textcraft.simulation.Noun;
import com.fabriziopolo.textcraft.simulation.Simulation;
import com.fabriziopolo.timecraft.world.dsl.jungle.Jungle;

public final class Plants
extends Jungle {
    private static final int MAX_NUM_FIGS = 3;

    public Plants(Simulation simulation) {
        super(simulation);
    }

    public Noun figTreeWithFigs(int numFigs) {
        Noun tree = this.figTree();
        for (int i = 0; i < numFigs; ++i) {
            this.put(this.foods().fig("red"), Prepositions.up, tree);
        }
        return tree;
    }

    public Noun figTreeWithRandomFigs() {
        return this.figTreeWithFigs(this.simulation.getRandom().nextInt(3));
    }

    public Noun figTree() {
        SimpleNoun atTree = SimpleNoun.autoBuilder().setDescription("A shrubby fig tree with dense foliage and twisted trunk seemingly made of fat braided vines.", "a fig tree", "trees", new String[0]).setDarkDescription("The outline of this small tree is barely visible against the stars.", "the outline of a large shrubby tree", "trees", new String[0]).build();
        SimpleNoun upTree = SimpleNoun.autoBuilder().setDescription(Nlg.literalSentences("Dense shrubby foliage surrounds you."), atTree.getContextFreeDescription()).setDarkDescription(Nlg.literalSentences("Thick corded branches support you while shrubby foliage scratches your skin."), atTree.getContextFreeDescription()).darkWhenBlind().build();
        Noun tree = this.beach().plants().createTree("fig", atTree, upTree);
        return tree;
    }
}

