/*
 * Decompiled with CFR 0.152.
 */
package com.fabriziopolo.timecraft.world.dsl.builds;

import com.fabriziopolo.textcraft.events.noun.NounEvent;
import com.fabriziopolo.textcraft.nlg.IndependentClause;
import com.fabriziopolo.textcraft.nlg.Nlg;
import com.fabriziopolo.textcraft.nlg.NounPhrase;
import com.fabriziopolo.textcraft.nlg.NounPhraseWithArticle;
import com.fabriziopolo.textcraft.nlg.Preposition;
import com.fabriziopolo.textcraft.nlg.Sentences;
import com.fabriziopolo.textcraft.objects.AbstractFuelAndActionNoun;
import com.fabriziopolo.textcraft.objects.SimpleNoun;
import com.fabriziopolo.textcraft.simulation.Frame;
import com.fabriziopolo.textcraft.simulation.Noun;
import com.fabriziopolo.textcraft.simulation.Simulation;
import com.fabriziopolo.textcraft.simulation.perception.Perceiver;
import com.fabriziopolo.textcraft.simulation.perception.PerceptionChannel;
import com.fabriziopolo.textcraft.states.ValueProvider;
import com.fabriziopolo.textcraft.states.capability.CapabilityImpl;
import com.fabriziopolo.textcraft.states.capability.ResourceState;
import com.fabriziopolo.textcraft.states.position.PositionState;
import com.fabriziopolo.textcraft.states.position.PositionStateBuilder;
import com.fabriziopolo.textcraft.states.position.SpacialRelationship;
import com.fabriziopolo.textcraft.states.scenery.DistanceLimitedScenery;
import com.fabriziopolo.textcraft.states.scenery.Scenery;
import com.fabriziopolo.textcraft.states.scenery.VisualScenery;
import com.fabriziopolo.textcraft.states.sun.SunState;
import com.fabriziopolo.textcraft.states.temperature.FlexibleHeatUnit;
import com.fabriziopolo.timecraft.capabilities.ResourceCapabilities;
import java.util.List;

public class Fire
extends AbstractFuelAndActionNoun {
    @Override
    protected boolean isFuel(Noun object, Frame frame) {
        return ResourceState.resourceSatisfiesCapability(object, ResourceCapabilities.BURNABLE_MATERIAL, frame);
    }

    @Override
    protected boolean isMaterial(Noun object, Frame frame) {
        return false;
    }

    @Override
    protected double getFuelAmount(Noun fuel, Frame frame) {
        return ResourceState.get(frame).getCapabilitiesSatisfying(fuel, ResourceCapabilities.BURNABLE_MATERIAL, frame).stream().mapToDouble(capability -> ((CapabilityImpl)capability).getRank()).sum();
    }

    @Override
    protected Noun getDelegate(List<Noun> fuels, List<Noun> materials, Frame frame) {
        return Fire.getDelegateFromDegree(this.getFireDegree(frame));
    }

    @Override
    protected void onOutOfFuel(Simulation simulation) {
        PositionState.requestRemove(this, simulation);
    }

    @Override
    protected void onFuelSpent(Noun fuel, Simulation simulation) {
        simulation.postEvent(new FuelSpentEvent(this, fuel));
    }

    public static double getFireBrightness(Noun lightSource, Noun otherNoun, Frame frame) {
        return 0.2;
    }

    private int getFireDegree(Frame frame) {
        return Fire.getFireDegree(this.getTotalFuelAmount(frame));
    }

    private static Noun getDelegateFromDegree(int degree) {
        if (degree <= 1) {
            SimpleNoun obj = SimpleNoun.autoBuilder().setDescription("A tiny smoldering ember.", "a smoldering ember", "embers", "fire", "fires").visibleInDark().build();
            return obj;
        }
        if (degree == 2) {
            SimpleNoun obj = SimpleNoun.autoBuilder().setDescription("A small campfire warms and lights the area.", "a small campfire", "campfires", "fire", "fires").visibleInDark().build();
            return obj;
        }
        if (degree == 3) {
            SimpleNoun obj = SimpleNoun.autoBuilder().setDescription("A campfire warms and lights the area.", "a campfire", "campfires", "fire", "fires").visibleInDark().build();
            return obj;
        }
        if (degree == 4) {
            SimpleNoun obj = SimpleNoun.autoBuilder().setDescription("A large campfire bathes the area with heat and light.", "a large campfire", "campfires", "fire", "fires").visibleInDark().build();
            return obj;
        }
        if (degree == 5) {
            SimpleNoun obj = SimpleNoun.autoBuilder().setDescription("A bonfire bathes the area with heat and light.", "a bonfire", "bonfires", "fire", "fires").visibleInDark().build();
            return obj;
        }
        if (degree == 6) {
            SimpleNoun obj = SimpleNoun.autoBuilder().setDescription("A large bonfire bathes the area with heat and light.", "a large bonfire", "bonfires", "fire", "fires").visibleInDark().build();
            return obj;
        }
        SimpleNoun obj = SimpleNoun.autoBuilder().setDescription("A raging bonfire scorches the local flora and fauna.", "a raging bonfire", "bonfires", "fire", "fires").visibleInDark().build();
        return obj;
    }

    private static int getFireDegree(double fuel) {
        if (fuel <= 0.0) {
            return 0;
        }
        if (fuel <= ResourceCapabilities.TINDER_MATERIAL.getRank()) {
            return 1;
        }
        int numSmallBurnables = 1 + (int)(fuel / ResourceCapabilities.SMALL_BURNABLE_MATERIAL.getRank());
        if (numSmallBurnables < 2) {
            return 2;
        }
        return numSmallBurnables;
    }

    public Scenery createScenery() {
        return new DistanceLimitedScenery(0.0, 8.0, new VisualScenery(new BaseFireScenery(this)));
    }

    private static final class BaseFireScenery
    implements Scenery {
        private final Fire fire;

        public BaseFireScenery(Fire fire) {
            this.fire = fire;
        }

        @Override
        public IndependentClause asPerceivedBy(Perceiver perceiver, Noun direction, Noun associatedNoun, PerceptionChannel channel, Frame frame) {
            if (!SunState.isNight(frame)) {
                return null;
            }
            if (this.fire.getFireDegree(frame) <= 1) {
                return null;
            }
            NounPhrase firePerception = this.fire.asPerceivedBy(perceiver, SpacialRelationship.of(direction), frame, channel);
            if (firePerception == null) {
                return null;
            }
            NounPhrase fireSpotPerception = PositionState.get(frame).getParent(this.fire).getDefaultPerception(frame);
            if (fireSpotPerception != null) {
                return Nlg.literalClause(NounPhraseWithArticle.a(firePerception) + " lights and warms " + NounPhraseWithArticle.the(fireSpotPerception));
            }
            return Nlg.literalClause(NounPhraseWithArticle.a(firePerception) + " burns");
        }
    }

    public static final class ProminenceProvider
    implements ValueProvider<Boolean, Void> {
        private final Fire fire;

        public ProminenceProvider(Fire fire) {
            this.fire = fire;
        }

        @Override
        public Boolean get(Noun noun, Void args, Frame frame) {
            if (this.fire.getFireDegree(frame) <= 1) {
                return false;
            }
            return SunState.isNight(frame);
        }
    }

    public static final class RainEffect
    implements com.fabriziopolo.textcraft.states.weather.rain.RainEffect {
        private final Fire fire;

        public RainEffect(Fire fire) {
            this.fire = fire;
        }

        @Override
        public void onRain(Noun target, double amount, Simulation simulation) {
            if (amount <= 0.0) {
                return;
            }
            int fireDegree = this.fire.getFireDegree(simulation.getCurrentFrame());
            if (fireDegree == 1) {
                this.fire.putOut(simulation);
            }
        }
    }

    public static final class HeatProvider
    implements ValueProvider<FlexibleHeatUnit, Void> {
        private final Fire fire;

        public HeatProvider(Fire fire) {
            this.fire = fire;
        }

        @Override
        public FlexibleHeatUnit get(Noun noun, Void args, Frame frame) {
            int fireDegree = this.fire.getFireDegree(frame);
            if (fireDegree <= 1) {
                return FlexibleHeatUnit.createNeutral();
            }
            double x = (double)fireDegree - 2.0;
            return FlexibleHeatUnit.createWithBounds(x * 0.25, 1.0 + x * 0.4);
        }
    }

    public static final class PutReceiver
    implements com.fabriziopolo.textcraft.states.putreceiver.PutReceiver {
        private final Fire fire;

        public PutReceiver(Fire fire) {
            this.fire = fire;
        }

        @Override
        public void handlePut(Noun nounToPut, Preposition preposition, Preposition reversePreposition, Noun putter, PositionStateBuilder partialState, Simulation simulation, Noun receivingFire) {
            if (receivingFire != this.fire) {
                throw new IllegalStateException("receivingFire != fire");
            }
            partialState.put(nounToPut, preposition, reversePreposition, receivingFire);
            if (this.fire.isFuel(nounToPut, simulation.getCurrentFrame())) {
                simulation.postEvent(new FuelAddedEvent(this.fire));
            }
        }
    }

    private static final class FuelAddedEvent
    extends NounEvent<Fire> {
        public FuelAddedEvent(Fire fire) {
            super(fire);
        }

        @Override
        protected Sentences asPerceivedBy(Perceiver perceiver, Noun noun, SpacialRelationship spacialRelationship, Frame frame, PerceptionChannel channel) {
            return Nlg.literalSentences("The fire grows.");
        }
    }

    private static final class FuelSpentEvent
    extends NounEvent<Fire> {
        private final Noun fuel;

        public FuelSpentEvent(Fire fire, Noun fuel) {
            super(fire);
            this.fuel = fuel;
        }

        @Override
        protected Sentences asPerceivedBy(Perceiver perceiver, Noun noun, SpacialRelationship spacialRelationship, Frame frame, PerceptionChannel channel) {
            if (channel == PerceptionChannel.BLIND) {
                return null;
            }
            Fire fire = (Fire)this.getNoun();
            double prevFuelAmount = fire.getTotalFuelAmount(frame);
            int prevDegree = Fire.getFireDegree(prevFuelAmount);
            double currFuelAmount = prevFuelAmount - fire.getFuelAmount(this.fuel, frame);
            int currDegree = Fire.getFireDegree(currFuelAmount);
            if (prevDegree == currDegree) {
                return null;
            }
            if (currFuelAmount == 0.0) {
                return Nlg.literalSentences("The fire has gone out.");
            }
            NounPhrase nounPhrase = Fire.getDelegateFromDegree(currDegree).asPerceivedBy(perceiver, spacialRelationship, frame, channel);
            if (nounPhrase == null) {
                return null;
            }
            return Nlg.literalSentences("The fire has dwindled to " + NounPhraseWithArticle.a(nounPhrase) + ".");
        }
    }
}

