/*
 * Decompiled with CFR 0.152.
 */
package com.fabriziopolo.timecraft.world.dsl.beach;

import com.fabriziopolo.textcraft.nlg.Nlg;
import com.fabriziopolo.textcraft.nlg.NounPhrase;
import com.fabriziopolo.textcraft.nlg.NounPhraseWithAlternatePlural;
import com.fabriziopolo.textcraft.nlg.NounPhraseWithPrepositionalPhrase;
import com.fabriziopolo.textcraft.nlg.Prepositions;
import com.fabriziopolo.textcraft.nlg.SimpleNounAutoBuilder;
import com.fabriziopolo.textcraft.objects.SimpleNoun;
import com.fabriziopolo.textcraft.player.Player;
import com.fabriziopolo.textcraft.simulation.Noun;
import com.fabriziopolo.textcraft.simulation.Simulation;
import com.fabriziopolo.textcraft.states.characterbio.CharacterBioEffect;
import com.fabriziopolo.textcraft.states.position.PositionStateBuilder;
import com.fabriziopolo.timecraft.capabilities.ResourceCapabilities;
import com.fabriziopolo.timecraft.tools.liquidcontainer.LiquidTakeHandler;
import com.fabriziopolo.timecraft.world.constants.Encumbrances;
import com.fabriziopolo.timecraft.world.dsl.Dsl;
import com.fabriziopolo.timecraft.world.dsl.beach.Beach;

public class Resources
extends Beach {
    private static CharacterBioEffect drinkSaltWaterEffect = CharacterBioEffect.builder().addHydration(-0.2).addHealth(-0.05).build();
    private static CharacterBioEffect drinkPotableWater = CharacterBioEffect.builder().addHydration(0.4).build();

    public Resources(Simulation simulation) {
        super(simulation);
    }

    public Noun shallowWater() {
        return new SimpleNounAutoBuilder().setDescription("The warm, coastal seawater is knee-deep.", "warm shallow coastal water", "water", new String[0]).alwaysVisible().build();
    }

    public Noun endlessSeaWater() {
        SimpleNoun obj = SimpleNoun.auto("The sea water is clear and warm.", "sea water", "waters", new String[0]);
        return obj;
    }

    public Noun seaWater() {
        SimpleNoun obj = SimpleNoun.auto("The sea water is clear and warm.", "sea water", "waters", new String[0]);
        this.setTakeHandler(obj, new LiquidTakeHandler());
        this.makeDrinkable(obj, "It is salty and makes you both thirsty and ill.  You regret this decision immediately.", drinkSaltWaterEffect);
        this.makeDisappearWhenDropped(obj);
        this.setEncumbrance(obj, Encumbrances.HAND_SIZED);
        return obj;
    }

    public Noun nonObviousSeawater() {
        SimpleNoun obj = SimpleNoun.auto("It's water.  What do you expect?", "water", "waters", new String[0]);
        this.setTakeHandler(obj, new LiquidTakeHandler());
        this.makeDrinkable(obj, "Yuck.  It's seawater.  You regret this decision immediately.", drinkSaltWaterEffect);
        this.makeDisappearWhenDropped(obj);
        this.setEncumbrance(obj, Encumbrances.HAND_SIZED);
        return obj;
    }

    public Noun potableWater() {
        SimpleNoun obj = SimpleNoun.auto("It's not the cleanest but it won't kill you either.", "water", "waters", new String[0]);
        this.setTakeHandler(obj, new LiquidTakeHandler());
        this.makeDrinkable(obj, "It tastes like plastic.", drinkPotableWater);
        this.makeDisappearWhenDropped(obj);
        this.setEncumbrance(obj, Encumbrances.HAND_SIZED);
        return obj;
    }

    public Noun rainWater() {
        SimpleNoun obj = SimpleNoun.auto("Clean, delicious rainwater", "water", "waters", new String[0]);
        this.setTakeHandler(obj, new LiquidTakeHandler());
        this.makeDrinkable(obj, "The rainwater is delicious.", drinkPotableWater);
        this.makeDisappearWhenDropped(obj);
        this.setEncumbrance(obj, Encumbrances.HAND_SIZED);
        return obj;
    }

    public void makeBehaveLikeEndlessSeawater(Noun seawater) {
        this.setTakeHandler(seawater, new EndlessSeawaterTakeHandler());
        this.makeEndlesslyDrinkable(seawater, "It is salty and makes you both thirsty and ill.  You regret this decision immediately.", drinkSaltWaterEffect);
    }

    public Noun whiteSand() {
        SimpleNoun obj = new SimpleNounAutoBuilder().setDescription("The sand is a fine, white quartz-based sand.", "white sand", "piles of sand", new String[0]).visibleInDark().build();
        this.setEncumbrance(obj, Encumbrances.HAND_SIZED);
        this.makeDisappearWhenDropped(obj);
        return obj;
    }

    public Noun roundPebble() {
        SimpleNoun pebbles = SimpleNoun.auto("This pebble small and worn round by the sea.", "a round pebble", "pebbles", new String[0]);
        this.givePebbleProperties(pebbles);
        return pebbles;
    }

    public Noun roughPebble(String color) {
        SimpleNoun pebbles = SimpleNoun.auto("This " + color + " pebble is still rough.  It is a newly formed volcanic rock.", "a rough " + color + " pebble", "pebbles", new String[0]);
        this.givePebbleProperties(pebbles);
        return pebbles;
    }

    private Noun givePebbleProperties(Noun noun) {
        this.setEncumbrance(noun, Encumbrances.MARBLE_SIZED);
        return noun;
    }

    public Noun flint() {
        SimpleNoun obj = SimpleNoun.auto("Flint is a brittle stone useful for crafting blades.", "flint", "flint", new String[0]);
        this.setEncumbrance(obj, Encumbrances.HALF_HAND_SIZED);
        this.addResourceCapability(obj, ResourceCapabilities.BLADE_MATERIAL);
        return obj;
    }

    public Noun driftwood() {
        SimpleNoun driftwood = SimpleNoun.auto("A stick of wood that once washed to shore.", "driftwood", "pieces of driftwood", "wood", "pieces of wood", "stick", "sticks", "stick", "sticks of wood", "stick", "sticks of driftwood");
        this.setEncumbrance(driftwood, Encumbrances.ARM_SIZED);
        this.addResourceCapability(driftwood, ResourceCapabilities.MINOR_BEAM_STRUCTURE);
        this.addResourceCapability(driftwood, ResourceCapabilities.HANDLE_MATERIAL);
        this.addResourceCapability(driftwood, ResourceCapabilities.SMALL_BURNABLE_MATERIAL);
        return driftwood;
    }

    public Noun beachGlass(String color) {
        String color_ = color == null ? " " : color + " ";
        NounPhrase piece = Nlg.autoNounPhrase("a piece", "pieces", new String[0]);
        NounPhrase singularBeachGlass = Nlg.autoNounPhrase(color_ + "beach glass", null, new String[0]);
        NounPhraseWithPrepositionalPhrase pluralBeachGlass = NounPhraseWithPrepositionalPhrase.builder().setBaseNounPhrase(piece).setPreposition(Prepositions.of).setObjectOfPreposition(singularBeachGlass).setMatchAsObjectOfPreposition(true).build();
        NounPhraseWithAlternatePlural beachGlassDescr = new NounPhraseWithAlternatePlural(singularBeachGlass, pluralBeachGlass);
        SimpleNoun obj = SimpleNoun.builder().setDescription(beachGlassDescr, Nlg.literalSentences("This curved piece of " + color_ + "beach glass has been rubbed smooth by sand and " + "waves, but it could still be useful for making something sharp.")).build();
        this.setEncumbrance(obj, Encumbrances.HALF_HAND_SIZED);
        this.addResourceCapability(obj, ResourceCapabilities.MINOR_BLADE_MATERIAL);
        return obj;
    }

    public Noun tangledFishingLine() {
        SimpleNoun obj = new SimpleNounAutoBuilder().setDescription("This blue fishing line is a tangled mess.  Catching fish with it seems doubtful but you could tie something together with it pretty effectively.", "tangled fishing line", "lines", new String[0]).build();
        this.setEncumbrance(obj, Encumbrances.NONE);
        this.addResourceCapability(obj, ResourceCapabilities.BINDING_MATEIRAL);
        return obj;
    }

    public Noun plasticBag(String color) {
        String _color_ = color == null ? " " : " " + color + " ";
        SimpleNoun obj = new SimpleNounAutoBuilder().setDescription("This tattered" + _color_ + "plastic grocery bag has seen better days.  " + "Holes in the bottom and missing handles make it useless for carrying anything.", "a tattered" + _color_ + "plastic grocery bag", "bags", new String[0]).build();
        this.setEncumbrance(obj, Encumbrances.NONE);
        return obj;
    }

    public Noun chunkOfRottenChipboard() {
        NounPhrase chunk = Nlg.autoNounPhrase("a chunk", "chunks", new String[0]);
        NounPhrase singularChipboard = Nlg.autoNounPhrase("chipboard", "chipboards", "board", "boards");
        NounPhraseWithPrepositionalPhrase chipboardDescription = NounPhraseWithPrepositionalPhrase.builder().setBaseNounPhrase(chunk).setPreposition(Prepositions.of).setObjectOfPreposition(singularChipboard).setMatchAsObjectOfPreposition(true).build();
        SimpleNoun obj = SimpleNoun.builder().setDescription(chipboardDescription, Nlg.literalSentences("This chunk of rotten chipboard is slightly larger than your hand.  It is mushy from being water-logged and has no structural value whatsoever.")).build();
        this.setEncumbrance(obj, Encumbrances.HAND_SIZED);
        return obj;
    }

    public Noun sixPackRings() {
        SimpleNoun obj = new SimpleNounAutoBuilder().setDescription("A six-ringed piece of disposable plastic that once held together some soda cans.", "a six pack ring", "rings", "rings", "rings").build();
        this.setEncumbrance(obj, Encumbrances.NONE);
        return obj;
    }

    public Noun pieceOfStyrofoam() {
        NounPhrase piece = Nlg.autoNounPhrase("a piece", "pieces", new String[0]);
        NounPhrase singularStyrofoam = Nlg.autoNounPhrase("styrofoam", "styrofoams", "foam", "foams");
        NounPhraseWithPrepositionalPhrase chipboardDescription = NounPhraseWithPrepositionalPhrase.builder().setBaseNounPhrase(piece).setPreposition(Prepositions.of).setObjectOfPreposition(singularStyrofoam).setMatchAsObjectOfPreposition(true).build();
        SimpleNoun obj = SimpleNoun.builder().setDescription(chipboardDescription, Nlg.literalSentences("A piece of dirty white styrofoam that looks to have once been the corner of some packaging.")).build();
        this.setEncumbrance(obj, Encumbrances.HAND_SIZED);
        return obj;
    }

    public Noun shredOfSeaweed() {
        NounPhrase shred = Nlg.autoNounPhrase("a shred", "shreds", new String[0]);
        NounPhrase singularSeaweed = Nlg.autoNounPhrase("seaweed", "seaweeds", "weed", "weeds");
        NounPhraseWithPrepositionalPhrase seaweedDescription = NounPhraseWithPrepositionalPhrase.builder().setBaseNounPhrase(shred).setPreposition(Prepositions.of).setObjectOfPreposition(singularSeaweed).setMatchAsObjectOfPreposition(true).build();
        SimpleNoun obj = SimpleNoun.builder().setDescription(seaweedDescription, Nlg.literalSentences("A tiny shred of black seaweed.")).build();
        this.setEncumbrance(obj, Encumbrances.NONE);
        return obj;
    }

    public Noun sandySoil() {
        SimpleNoun obj = SimpleNoun.auto("The soil is dry and sandy.", "sandy soil", "soil", new String[0]);
        this.setEncumbrance(obj, Encumbrances.HAND_SIZED);
        return obj;
    }

    private class EndlessSeawaterTakeHandler
    extends LiquidTakeHandler {
        private EndlessSeawaterTakeHandler() {
        }

        @Override
        public Noun willProduceOne(Player player, Noun nounToTake, Noun tool, Simulation simulation, PositionStateBuilder partialState) {
            return new Dsl(simulation).beach().resources().seaWater();
        }
    }
}

