/*
 * Decompiled with CFR 0.152.
 */
package com.fabriziopolo.timecraft.commands;

import com.fabriziopolo.textcraft.commands.AbstractCraftCommand;
import com.fabriziopolo.textcraft.commands.BuildCommand;
import com.fabriziopolo.textcraft.commands.BuildCraftingDelegate;
import com.fabriziopolo.textcraft.nlg.NounPhraseWithArticle;
import com.fabriziopolo.textcraft.nlg.Preposition;
import com.fabriziopolo.textcraft.nlg.Prepositions;
import com.fabriziopolo.textcraft.objects.EmptyNoun;
import com.fabriziopolo.textcraft.player.Player;
import com.fabriziopolo.textcraft.simulation.Frame;
import com.fabriziopolo.textcraft.simulation.Noun;
import com.fabriziopolo.textcraft.simulation.Simulation;
import com.fabriziopolo.textcraft.states.capability.Capability;
import com.fabriziopolo.textcraft.states.position.PositionState;
import com.fabriziopolo.timecraft.capabilities.ResourceCapabilities;
import com.fabriziopolo.timecraft.capabilities.ToolCapabilities;
import com.fabriziopolo.timecraft.world.dsl.Dsl;
import com.fabriziopolo.timecraft.world.dsl.builds.Fire;
import edu.emory.mathcs.backport.java.util.Arrays;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

public final class Builds
implements Serializable {
    private final Dsl dsl;
    private final Noun LEAN_TO_PROTOTYPE;
    private static final List<Capability> leantoResourceRequirements = Arrays.asList(new Capability[]{ResourceCapabilities.MINOR_VERTICAL_STRUCTURE, ResourceCapabilities.MINOR_BEAM_STRUCTURE, ResourceCapabilities.MINOR_ROOF_STRUCTURE});
    private final Noun FIRE_PROTOTYPE;
    private static final List<Capability> fireResourceRequirements = Arrays.asList(new Capability[]{ResourceCapabilities.TINDER_MATERIAL});

    public Builds(Simulation simulation) {
        this.dsl = new Dsl(simulation);
        ArrayList<Noun> fakeResources = new ArrayList<Noun>();
        for (int i = 0; i < 10; ++i) {
            fakeResources.add(new EmptyNoun());
        }
        this.LEAN_TO_PROTOTYPE = this.dsl.shelters().leanToShelter(null, fakeResources, null);
        this.FIRE_PROTOTYPE = this.dsl.fires().firePrototype();
    }

    public BuildCommand leanToShelter() {
        return new BuildCommand(new BuildLeanToShelter());
    }

    public BuildCommand fire() {
        return new BuildCommand(new BuildFire());
    }

    private final class BuildFire
    extends BuildCraftingDelegate {
        protected BuildFire() {
            super(Builds.this.FIRE_PROTOTYPE, (List<Capability>)fireResourceRequirements, ToolCapabilities.FIRE_MAKING);
        }

        @Override
        public Noun craftNewNoun(AbstractCraftCommand.ParseResult result) {
            Simulation simulation = result.context.simulation;
            Frame frame = simulation.getCurrentFrame();
            Player player = result.context.player;
            Dsl dsl = new Dsl(simulation);
            Fire fire = dsl.fires().fire(result.resources);
            Noun room = PositionState.get(frame).getContainingRoom(player);
            dsl.putInRoom(fire, room);
            fire.ignite(simulation);
            return fire;
        }

        @Override
        public String getHint() {
            return "If you want to craft " + NounPhraseWithArticle.a(Builds.this.FIRE_PROTOTYPE.getContextFreeDescription()) + " you will need something dry and flammable for the tinder and you will have to use a tool to light it.  " + "For instance 'craft fire from newspaper with match' would work if you had those things.";
        }
    }

    private final class BuildLeanToShelter
    extends BuildCraftingDelegate {
        protected BuildLeanToShelter() {
            super(Builds.this.LEAN_TO_PROTOTYPE, leantoResourceRequirements);
        }

        @Override
        public Noun craftNewNoun(AbstractCraftCommand.ParseResult result) {
            Preposition prepositionOfSpot;
            Noun spotToBuildShelter;
            List<Noun> resources = result.resources;
            Simulation simulation = result.context.simulation;
            Frame frame = simulation.getCurrentFrame();
            Player player = result.context.player;
            PositionState positionState = PositionState.get(frame);
            Noun verticalSupport = resources.get(0);
            PositionState.requestRemove(resources.get(1), simulation);
            PositionState.requestRemove(resources.get(2), simulation);
            Noun playerSpot = positionState.getParent(player);
            if (playerSpot == verticalSupport) {
                spotToBuildShelter = playerSpot;
                prepositionOfSpot = positionState.getPreposition(player);
            } else {
                spotToBuildShelter = verticalSupport;
                prepositionOfSpot = Prepositions.under;
            }
            Dsl worldBuilder = new Dsl(simulation);
            Noun leanTo = worldBuilder.shelters().leanToShelter(result.adjective, resources, spotToBuildShelter);
            worldBuilder.put(leanTo, prepositionOfSpot, spotToBuildShelter);
            return leanTo;
        }

        @Override
        public String getHint() {
            return "If you want to craft " + NounPhraseWithArticle.a(Builds.this.LEAN_TO_PROTOTYPE.getContextFreeDescription()) + " you will need a tree or other vertical object, something for the structure, " + "and something to cover the roof.";
        }
    }
}

