/*
 * Decompiled with CFR 0.152.
 */
package com.fabriziopolo.timecraft.capabilities;

import com.fabriziopolo.textcraft.simulation.Frame;
import com.fabriziopolo.textcraft.simulation.Noun;
import com.fabriziopolo.textcraft.states.capability.Capability;
import com.fabriziopolo.textcraft.states.capability.CapabilityImpl;
import com.fabriziopolo.textcraft.states.inventory.InventoryState;
import com.fabriziopolo.textcraft.states.position.PositionState;
import com.fabriziopolo.textcraft.states.sun.SunState;

public class ToolCapabilities {
    public static final LiquidContainer LIQUID_CONTAINER = new LiquidContainer();
    public static final FireMaking FIRE_MAKING = new FireMaking();
    public static final FireMakingWithLight FIRE_MAKING_WITH_LIGHT = new FireMakingWithLight();
    public static final Cutting CUTTING = new Cutting(0.0, "cutting tool");
    public static final Cutting KNIFE_CUTTING = new Cutting(1.0, "cutting tool");
    public static final Cutting TREE_CUTTING = new Cutting(2.0, "cutting tool");
    public static final Hammer HAMMER = new Hammer(0.0, "hammer");

    public static class Hammer
    extends CapabilityImpl {
        public Hammer(double rank, String nounDescription) {
            super(rank, nounDescription);
        }
    }

    public static class Cutting
    extends CapabilityImpl {
        public Cutting(double rank, String nounDescription) {
            super(rank, nounDescription);
        }
    }

    public static class FireMakingWithLight
    extends FireMaking {
        private static final double BRIGHTNESS_THRESHOLD = 0.5;

        @Override
        protected Capability.Result satisfies(Noun tool, FireMaking toolRequirement, Frame frame) {
            Noun toolSpot = InventoryState.getLocation(tool, frame);
            Noun parent = PositionState.get(frame).getParent(toolSpot);
            if (parent != null) {
                toolSpot = parent;
            }
            if (SunState.get(frame).getIntensityAt(toolSpot, frame) < 0.5) {
                return Capability.Result.createFailure("there isn't enough sunlight");
            }
            return Capability.Result.createSuccess();
        }
    }

    public static class FireMaking
    implements Capability {
        protected Capability.Result satisfies(Noun tool, FireMaking toolRequirement, Frame frame) {
            return Capability.Result.createSuccess();
        }

        @Override
        public Capability.Result isSatisfiedBy(Noun tool, Capability toolCapability, Frame frame) {
            if (!(toolCapability instanceof FireMaking)) {
                return Capability.Result.createFailure();
            }
            return ((FireMaking)toolCapability).satisfies(tool, this, frame);
        }

        public String toString() {
            return this.getClass().getSimpleName() + "()";
        }

        @Override
        public String getNounDescription() {
            return "fire making tool";
        }
    }

    public static class LiquidContainer
    extends CapabilityImpl {
        public LiquidContainer() {
            super(0.0, "liquid container");
        }
    }
}

