/*
 * Decompiled with CFR 0.152.
 */
package com.fabriziopolo.textcraft.worldbuilder;

import com.fabriziopolo.textcraft.nlg.Preposition;
import com.fabriziopolo.textcraft.nlg.Prepositions;
import com.fabriziopolo.textcraft.objects.EmptyNoun;
import com.fabriziopolo.textcraft.simulation.Frame;
import com.fabriziopolo.textcraft.simulation.Noun;
import com.fabriziopolo.textcraft.simulation.Simulation;
import com.fabriziopolo.textcraft.states.ValueProvider;
import com.fabriziopolo.textcraft.states.capability.Capability;
import com.fabriziopolo.textcraft.states.capability.ResourceState;
import com.fabriziopolo.textcraft.states.capability.ToolState;
import com.fabriziopolo.textcraft.states.characterbio.CharacterBioEffect;
import com.fabriziopolo.textcraft.states.characterbio.health.HealthState;
import com.fabriziopolo.textcraft.states.characterbio.hunger.HungerState;
import com.fabriziopolo.textcraft.states.characterbio.hydration.HydrationState;
import com.fabriziopolo.textcraft.states.constants.Directions;
import com.fabriziopolo.textcraft.states.constants.SpacialRelationships;
import com.fabriziopolo.textcraft.states.coordinate.CoordinateState;
import com.fabriziopolo.textcraft.states.coordinate.Coordinates;
import com.fabriziopolo.textcraft.states.description.DescriptionState;
import com.fabriziopolo.textcraft.states.description.ProminenceState;
import com.fabriziopolo.textcraft.states.droppable.DisappearsDropHandler;
import com.fabriziopolo.textcraft.states.droppable.DropHandler;
import com.fabriziopolo.textcraft.states.droppable.DroppableState;
import com.fabriziopolo.textcraft.states.edibility.CharacterBioEdibleEffect;
import com.fabriziopolo.textcraft.states.edibility.EdibilityState;
import com.fabriziopolo.textcraft.states.edibility.EdibleEffect;
import com.fabriziopolo.textcraft.states.edibility.EdibleEffectWithMessage;
import com.fabriziopolo.textcraft.states.edibility.EndlesslyEdibleEatHandler;
import com.fabriziopolo.textcraft.states.encumbrance.EncumbranceState;
import com.fabriziopolo.textcraft.states.goability.GoHandler;
import com.fabriziopolo.textcraft.states.goability.GoableState;
import com.fabriziopolo.textcraft.states.goability.RedirectToRoomGoHandler;
import com.fabriziopolo.textcraft.states.goability.RedirectingGoHandler;
import com.fabriziopolo.textcraft.states.inventory.InventoryState;
import com.fabriziopolo.textcraft.states.light.LightState;
import com.fabriziopolo.textcraft.states.perception.BlocksPerceptionFilter;
import com.fabriziopolo.textcraft.states.perception.PerceptionFilter;
import com.fabriziopolo.textcraft.states.perception.PerceptionFilterState;
import com.fabriziopolo.textcraft.states.position.PositionState;
import com.fabriziopolo.textcraft.states.position.RoomExitLink;
import com.fabriziopolo.textcraft.states.position.SpacialRelationship;
import com.fabriziopolo.textcraft.states.putreceiver.PutReceiver;
import com.fabriziopolo.textcraft.states.putreceiver.PutReceiverState;
import com.fabriziopolo.textcraft.states.room.RoomState;
import com.fabriziopolo.textcraft.states.scenery.Scenery;
import com.fabriziopolo.textcraft.states.scenery.SceneryState;
import com.fabriziopolo.textcraft.states.shade.MaxShadeLightFilter;
import com.fabriziopolo.textcraft.states.shade.MultiplierLightFilter;
import com.fabriziopolo.textcraft.states.shade.ShadeState;
import com.fabriziopolo.textcraft.states.singleplayer.WaitState;
import com.fabriziopolo.textcraft.states.structure.PassageFilter;
import com.fabriziopolo.textcraft.states.structure.StructureState;
import com.fabriziopolo.textcraft.states.takeable.TakeHandler;
import com.fabriziopolo.textcraft.states.takeable.TakeableState;
import com.fabriziopolo.textcraft.states.temperature.FlexibleHeatUnit;
import com.fabriziopolo.textcraft.states.temperature.TemperatureEffect;
import com.fabriziopolo.textcraft.states.temperature.TemperatureEffectState;
import com.fabriziopolo.textcraft.states.temperature.TemperatureFilterState;
import com.fabriziopolo.textcraft.states.temperature.TemperatureState;
import com.fabriziopolo.textcraft.states.updatable.Updateable;
import com.fabriziopolo.textcraft.states.updatable.UpdateableState;
import com.fabriziopolo.textcraft.states.useable.UseHandler;
import com.fabriziopolo.textcraft.states.useable.UseableState;
import com.fabriziopolo.textcraft.states.water.WaterState;
import com.fabriziopolo.textcraft.states.wearabililty.WearabilityState;
import com.fabriziopolo.textcraft.states.wearabililty.WearableCategory;
import com.fabriziopolo.textcraft.states.weather.rain.BlocksRainState;
import com.fabriziopolo.textcraft.states.weather.rain.RainEffect;
import com.fabriziopolo.textcraft.states.weather.rain.RainEffectState;
import java.io.Serializable;

public class WorldBuilder
implements Serializable {
    protected final Simulation simulation;

    public WorldBuilder(Simulation simulation) {
        this.simulation = simulation;
    }

    public HungerState hunger() {
        return HungerState.get(this.simulation.getCurrentFrame());
    }

    public HydrationState hydration() {
        return HydrationState.get(this.simulation.getCurrentFrame());
    }

    public RoomState room() {
        return RoomState.get(this.simulation.getCurrentFrame());
    }

    public EdibilityState edibility() {
        return EdibilityState.get(this.simulation.getCurrentFrame());
    }

    public Directions directions() {
        return Directions.get(this.simulation.getCurrentFrame());
    }

    public StructureState structure() {
        return StructureState.get(this.simulation.getCurrentFrame());
    }

    public void putRoom(Noun noun, Preposition preposition, Noun roomNoun) {
        Noun floor = this.room().getFloor(roomNoun);
        if (floor == null) {
            throw new IllegalStateException("putInRoom() expects the room to have a floor.");
        }
        this.put(noun, preposition, floor);
    }

    public void putInRoom(Noun noun, Noun roomNoun) {
        this.putRoom(noun, Prepositions.on, roomNoun);
    }

    public void putIntegral(Noun noun, Preposition preposition, Noun spot) {
        this.putIntegral(noun, preposition, Prepositions.guessInverseOf(preposition), spot);
    }

    public void putIntegral(Noun noun, Preposition preposition, Preposition reversePreposition, Noun spot) {
        this.put(noun, preposition, reversePreposition, spot);
        StructureState.requestMakeIntegral(noun, this.simulation);
    }

    public void put(Noun noun, Preposition preposition, Noun spot) {
        this.put(noun, preposition, Prepositions.guessInverseOf(preposition), spot);
    }

    public void put(Noun noun, Preposition preposition, Preposition reversePreposition, Noun spot) {
        PositionState.requestPut(noun, preposition, reversePreposition, spot, this.simulation);
    }

    public void createExit(Noun roomNoun1, SpacialRelationship direction, Noun roomNoun2) {
        SpacialRelationship oppositeDirection = SpacialRelationships.getOppositeOf(direction, this.simulation.getCurrentFrame());
        RoomExitLink roomExitLink = new RoomExitLink(new EmptyNoun(), roomNoun2, oppositeDirection);
        PositionState.requestPutExit(roomNoun1, direction, roomExitLink, this.simulation);
    }

    public Noun makeEntrance(Noun noun, Noun direction) {
        return this.makeEntrance(noun, SpacialRelationship.of(direction));
    }

    public void makeEntrance(Noun noun, Noun direction, Noun entranceNoun) {
        this.makeEntrance(noun, SpacialRelationship.of(direction), entranceNoun);
    }

    public Noun makeEntrance(Noun noun, Preposition preposition) {
        return this.makeEntrance(noun, SpacialRelationship.of(preposition));
    }

    public void makeEntrance(Noun noun, Preposition preposition, Noun entranceNoun) {
        this.makeEntrance(noun, SpacialRelationship.of(preposition), entranceNoun);
    }

    public void makeEntrance(Noun noun, SpacialRelationship spacialRelationship, Noun entranceNoun) {
        PositionState.requestPutEntrance(noun, spacialRelationship, entranceNoun, this.simulation);
    }

    public Noun makeEntrance(Noun noun, SpacialRelationship spacialRelationship) {
        EmptyNoun entrance = new EmptyNoun();
        PositionState.requestPutEntrance(noun, spacialRelationship, entrance, this.simulation);
        return entrance;
    }

    public void createExitAndEntranceToRoomAndFloor(Noun roomNoun1, Noun direction, Noun roomNoun2) {
        this.createExitAndEntranceToRoomAndFloor(roomNoun1, SpacialRelationship.of(direction), roomNoun2);
    }

    public void createExitAndEntranceToRoomAndFloor(Noun roomNoun1, SpacialRelationship direction, Noun roomNoun2) {
        this.createExit(roomNoun1, direction, roomNoun2);
        SpacialRelationship oppositeDirection = SpacialRelationships.getOppositeOf(direction, this.simulation.getCurrentFrame());
        Noun floor2 = RoomState.get(this.simulation.getCurrentFrame()).getFloor(roomNoun2);
        this.makeEntrance(floor2, oppositeDirection);
        this.makeEntrance(roomNoun2, oppositeDirection);
    }

    public void give(Noun person, Noun object) {
        InventoryState.requestAddItem(person, object, this.simulation);
    }

    public void wear(Noun person, Noun wearable, WearableCategory category) {
        InventoryState.requestWearItem(person, wearable, category, this.simulation);
    }

    public void addWaterDepth(Noun roomNoun, double depth) {
        WaterState.requestAddDepth(roomNoun, depth, this.simulation);
    }

    public void makeIntegral(Noun noun) {
        StructureState.requestMakeIntegral(noun, this.simulation);
    }

    public void makeSurrounding(Preposition preposition, Noun noun) {
        StructureState.requestMakeSurrounding(noun, preposition, this.simulation);
    }

    public void setPassageFilter(Noun interfaceNoun, PassageFilter filter) {
        StructureState.requestSetPassageFilter(interfaceNoun, filter, this.simulation);
    }

    public void setTakeHandler(Noun noun, TakeHandler handler) {
        TakeableState.requestChange(noun, handler, this.simulation);
    }

    public void makeUntakeable(Noun noun, String message) {
        TakeableState.requestUntakeable(noun, message, this.simulation);
    }

    public void makeExternallyInvisible(Noun noun) {
        DescriptionState.requestSetExternallyVisible(noun, false, this.simulation);
    }

    public void makeProminent(Noun noun) {
        ProminenceState.requestSetProminent(noun, this.simulation);
    }

    public void setProminent(Noun noun, ValueProvider<Boolean, Void> provider) {
        ProminenceState.requestSetProminenceProvider(this.simulation, noun, provider);
    }

    public void makeEdible(Noun noun, EdibleEffect effect) {
        EdibilityState.requestChange(noun, effect, this.simulation);
    }

    public void makeEdible(Noun noun, String message, EdibleEffect effect) {
        EdibilityState.requestChange(noun, new EdibleEffectWithMessage(effect, message), null, this.simulation);
    }

    public void makeEdible(Noun noun, String message, CharacterBioEffect effect) {
        EdibilityState.requestChange(noun, new EdibleEffectWithMessage(new CharacterBioEdibleEffect(effect), message), null, this.simulation);
    }

    public void makeEndlesslyEdible(Noun noun, String message, CharacterBioEffect effect) {
        EdibilityState.requestChange(noun, new EdibleEffectWithMessage(new CharacterBioEdibleEffect(effect), message), EndlesslyEdibleEatHandler.instance, this.simulation);
    }

    public void makeDrinkable(Noun noun, EdibleEffect effect) {
        this.makeEdible(noun, effect);
    }

    public void makeDrinkable(Noun noun, String message, CharacterBioEffect effect) {
        this.makeEdible(noun, message, effect);
    }

    public void makeEndlesslyDrinkable(Noun noun, String message, CharacterBioEffect effect) {
        this.makeEndlesslyEdible(noun, message, effect);
    }

    public void putScenery(Noun noun, Scenery scenery) {
        SceneryState.requestPut(noun, scenery, this.simulation);
    }

    public void addToolCapability(Noun tool, Capability capability) {
        ToolState.requestAddCapability(tool, capability, this.simulation);
    }

    public void addResourceCapability(Noun item, Capability capability) {
        ResourceState.requestAddCapability(item, capability, this.simulation);
    }

    public void makeLightSource(Noun noun, double brightness) {
        LightState.requestSetBrightness(noun, brightness, this.simulation);
    }

    public void makeLightSource(Noun noun, ValueProvider<Double, Noun> brightnessProvider) {
        LightState.requestSetBrightness(noun, brightnessProvider, this.simulation);
    }

    public void setRainEffect(Noun noun, RainEffect effect) {
        RainEffectState.requestSetRainEffect(noun, effect, this.simulation);
    }

    public void makeProvideMaxShade(Noun entrance) {
        ShadeState.requestSetLightFilter(entrance, new MaxShadeLightFilter(), this.simulation);
    }

    public void makeProvidePartialShade(Noun entrance, double multiplier) {
        ShadeState.requestSetLightFilter(entrance, new MultiplierLightFilter(multiplier), this.simulation);
    }

    public void makeGoToSpot(Noun spot, Preposition preposition, Noun goToSpot) {
        this.makeGoToSpot(spot, SpacialRelationship.of(preposition), goToSpot);
    }

    public void makeGoToSpot(Noun spot, SpacialRelationship spacialRelationship, Noun goToSpot) {
        GoableState.requestChange(spot, spacialRelationship, new RedirectingGoHandler(goToSpot), this.simulation);
    }

    public void makeGoToRoom(Noun spot, Noun direction, Noun spotInRoom) {
        GoableState.requestChange(spot, SpacialRelationship.of(direction), new RedirectToRoomGoHandler(spotInRoom), this.simulation);
    }

    public void setGoHandler(Noun spot, Noun direction, GoHandler handler) {
        GoableState.requestChange(spot, SpacialRelationship.of(direction), handler, this.simulation);
    }

    public void setGoHandler(Noun spot, Preposition preposition, GoHandler handler) {
        GoableState.requestChange(spot, SpacialRelationship.of(preposition), handler, this.simulation);
    }

    public void setGoHandlerInAllDirections(Noun spot, GoHandler handler) {
        this.directions().getAll().forEach(direction -> GoableState.requestChange(spot, SpacialRelationship.of(direction), handler, this.simulation));
    }

    public void makeBlockRain(Noun noun) {
        BlocksRainState.requestBlocksRain(noun, this.simulation);
    }

    public void makeWearable(Noun noun, WearableCategory category) {
        WearabilityState.requestWearable(noun, category, this.simulation);
    }

    public void setPutReceiver(Noun noun, PutReceiver handler) {
        PutReceiverState.requestSetHandler(noun, handler, this.simulation);
    }

    public void setUpdateable(Noun noun, Updateable updateable) {
        UpdateableState.requestSetUpdateable(noun, updateable, this.simulation);
    }

    public void createUpdateable(Updateable updateable) {
        UpdateableState.requestCreateUpdateable(this.simulation, updateable);
    }

    public void setPerceptionFilter(Noun noun, PerceptionFilter filter) {
        PerceptionFilterState.requestSetPerceptionFilter(noun, filter, this.simulation);
    }

    public void makeBlockPerception(Noun noun) {
        this.setPerceptionFilter(noun, new BlocksPerceptionFilter());
    }

    public void setTemperature(Noun noun, ValueProvider<FlexibleHeatUnit, Void> heatProvider) {
        TemperatureState.requestSetHeatProvider(this.simulation, noun, heatProvider);
    }

    public void setTemperature(Noun noun, FlexibleHeatUnit heatUnit) {
        this.setTemperature(noun, (Noun noun1, Void args, Frame frame) -> heatUnit);
    }

    public void setTemperatureEffect(Noun noun, TemperatureEffect filter) {
        TemperatureEffectState.requestSetEffect(this.simulation, noun, filter);
    }

    public void setNotWaiting(Noun noun) {
        WaitState.requestStopWaiting(noun, this.simulation);
    }

    public void setCoordinates(Noun noun, double x, double y) {
        CoordinateState.reqeustPut(noun, new Coordinates(x, y), this.simulation);
    }

    public void setUse(Noun noun, UseHandler use) {
        UseableState.requestSetUse(noun, use, this.simulation);
    }

    public void setTemperatureFilter(Noun noun, FlexibleHeatUnit deltaHeat) {
        TemperatureFilterState.requestSetTemperatureFilter(noun, deltaHeat, this.simulation);
    }

    public void setHealth(Noun noun, double health) {
        HealthState.requestChangeWithoutCause(noun, health, this.simulation);
    }

    public void setEncumbrance(Noun noun, double encumbrance) {
        EncumbranceState.requestSet(noun, encumbrance, this.simulation);
    }

    public void setDropHandler(Noun noun, DropHandler handler) {
        DroppableState.requestChange(noun, handler, this.simulation);
    }

    public void makeDisappearWhenDropped(Noun noun) {
        this.setDropHandler(noun, DisappearsDropHandler.INSTANCE);
    }

    public void update() {
        this.simulation.update();
    }
}

