/*
 * Decompiled with CFR 0.152.
 */
package com.fabriziopolo.textcraft.wiki;

import com.fabriziopolo.textcraft.commands.AbstractCraftCommand;
import com.fabriziopolo.textcraft.commands.DefaultCraftingDelegateImpl;
import com.fabriziopolo.textcraft.nlg.NounPhraseWithArticle;
import com.fabriziopolo.textcraft.simulation.Frame;
import com.fabriziopolo.textcraft.simulation.Noun;
import com.fabriziopolo.textcraft.states.capability.Capability;
import com.fabriziopolo.textcraft.states.capability.ResourceState;
import com.fabriziopolo.textcraft.states.capability.ToolState;
import com.fabriziopolo.textcraft.states.encumbrance.EncumbranceState;
import com.fabriziopolo.textcraft.wiki.ObjectTemplate;

public final class WikiRenderer {
    private final Frame frame;

    public WikiRenderer(Frame frame) {
        this.frame = frame;
    }

    public String getWikiDesciption(Noun noun) {
        return this.getWikiTemplate(noun).render();
    }

    public String getWikiDesciption(AbstractCraftCommand.CraftingDelegate delegate) {
        DefaultCraftingDelegateImpl craft = (DefaultCraftingDelegateImpl)delegate;
        ObjectTemplate wikiTemplate = this.getWikiTemplate(craft.getPrototype());
        StringBuilder recipe = new StringBuilder();
        for (Capability capability : craft.getResourceRequirements()) {
            recipe.append(capability);
            recipe.append(" ");
        }
        Capability toolRequirement = craft.getToolRequirement();
        if (toolRequirement != null) {
            recipe.append(toolRequirement);
        }
        wikiTemplate.recipe = recipe.toString();
        return wikiTemplate.render();
    }

    private ObjectTemplate getWikiTemplate(Noun noun) {
        String capabilitiesString = ResourceState.get(this.frame).getCapabilities(noun).toString();
        String toolsString = ToolState.get(this.frame).getCapabilities(noun).toString();
        ObjectTemplate obj = new ObjectTemplate();
        obj.name = NounPhraseWithArticle.a(noun.getContextFreeDescription()).toString();
        obj.resource = capabilitiesString.substring(1, capabilitiesString.length() - 1);
        obj.tool = toolsString.substring(1, toolsString.length() - 1);
        obj.encumbrance = EncumbranceState.get(noun, this.frame);
        return obj;
    }
}

