/*
 * Decompiled with CFR 0.152.
 */
package com.fabriziopolo.textcraft.text;

import com.fabriziopolo.textcraft.commands.ActionsAndHints;
import com.fabriziopolo.textcraft.commands.Command;
import com.fabriziopolo.textcraft.commands.ExamineCommand;
import com.fabriziopolo.textcraft.commands.HelpCommand;
import com.fabriziopolo.textcraft.nlg.Nlg;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class InputParser
implements Serializable {
    private final List<Command> commands = new ArrayList<Command>();

    public void addCommand(Command command) {
        this.commands.add(command);
    }

    public void addCommands(Collection<Command> commands) {
        this.commands.addAll(commands);
    }

    public ActionsAndHints parse(String input, Command.Context context) {
        String[] words = InputParser.splitIntoWords(input);
        return this.parseWords(words, context);
    }

    public static String[] splitIntoWords(String input) {
        String[] words = (input = input.replace(",", " , ")).split("\\s+");
        if (words.length == 1 && words[0].isEmpty()) {
            return new String[0];
        }
        return words;
    }

    private ActionsAndHints parseWords(String[] words, Command.Context context) {
        ActionsAndHints allResultsAndHints = new ActionsAndHints();
        for (Command command : this.commands) {
            ActionsAndHints resultsAndHints = command.parse(words, context);
            if (resultsAndHints == null) continue;
            if (resultsAndHints.actions != null) {
                allResultsAndHints.addAllActions(resultsAndHints.actions);
            }
            if (resultsAndHints.hints == null) continue;
            allResultsAndHints.addAllHints(resultsAndHints.hints);
        }
        if (allResultsAndHints.actions.isEmpty() && allResultsAndHints.hints.isEmpty()) {
            this.addHintsIfNoResults(allResultsAndHints, words);
        }
        return allResultsAndHints;
    }

    private void addHintsIfNoResults(ActionsAndHints allResultsAndHints, String[] words) {
        boolean helpCommandPresent = this.commands.stream().filter(command -> command instanceof HelpCommand).findFirst().isPresent();
        boolean examineCommandPresent = this.commands.stream().filter(command -> command instanceof ExamineCommand).findFirst().isPresent();
        if (helpCommandPresent) {
            if (examineCommandPresent && words.length > 0) {
                allResultsAndHints.addHint("Come again?  " + Nlg.literalClauseSentence(words[0] + " is not a command or nearby object.  " + "Type 'help' for a list of commands"));
            } else {
                allResultsAndHints.addHint("Come again?  Type 'help' for a list of commands.");
            }
        } else {
            allResultsAndHints.addHint("Come again?");
        }
    }
}

