/*
 * Decompiled with CFR 0.152.
 */
package com.fabriziopolo.textcraft.states.weather;

import com.fabriziopolo.textcraft.events.weather.WeatherChangedEvent;
import com.fabriziopolo.textcraft.nlg.Nlg;
import com.fabriziopolo.textcraft.nlg.Sentences;
import com.fabriziopolo.textcraft.simulation.Frame;
import com.fabriziopolo.textcraft.simulation.Noun;
import com.fabriziopolo.textcraft.simulation.Simulation;
import com.fabriziopolo.textcraft.simulation.State;
import com.fabriziopolo.textcraft.simulation.UpdateParameters;
import com.fabriziopolo.textcraft.states.sun.SunState;
import com.fabriziopolo.textcraft.states.temperature.FlexibleHeatUnit;
import com.fabriziopolo.textcraft.states.time.TimeState;
import com.fabriziopolo.textcraft.states.weather.WeatherProvider;
import com.fabriziopolo.textcraft.states.weather.rain.RainEffectState;
import com.fabriziopolo.textcraft.text.DebugInfoBuilder;

public class WeatherState
implements State {
    private static final double DEFAULT_INTENSITY = 1.0;
    private static final double SUN_INTENSITY_HEAT_RATE = 2.0;
    private static final double RAIN_TEMPERATURE_DELTA = -1.5;
    private final WeatherProvider weatherProvider;

    public WeatherState(WeatherProvider weatherProvider) {
        this.weatherProvider = weatherProvider;
    }

    public static WeatherState get(Frame frame) {
        return (WeatherState)frame.states.get(WeatherState.class);
    }

    @Override
    public State updateState(Simulation simulation) {
        UpdateParameters params = simulation.getUpdateParameters();
        Frame frame = simulation.getCurrentFrame();
        double timeHours = TimeState.getGameTimeElapsedHoursSinceDay0(frame);
        double timeHoursLastFrame = timeHours - params.getGameTimeDtSeconds() / 3600.0;
        boolean isRainingNow = this.weatherProvider.isRainingAtHours(timeHours);
        boolean wasRaining = this.weatherProvider.isRainingAtHours(timeHoursLastFrame);
        if (isRainingNow && !wasRaining) {
            simulation.postEvent(new WeatherChangedEvent("It is beginning to rain."));
        } else if (!isRainingNow && wasRaining) {
            simulation.postEvent(new WeatherChangedEvent("The rain has stopped."));
        }
        if (isRainingNow) {
            RainEffectState.invokeRainEffects(1.0, simulation);
        }
        return this;
    }

    @Override
    public String getDebugInfo(Noun noun, Frame frame) {
        DebugInfoBuilder builder = new DebugInfoBuilder(WeatherState.class);
        builder.addLine("airTemperature", WeatherState.getAirTemperatureAt(noun, frame));
        builder.addLine("sunTemperatureAt", WeatherState.getSunTemperatureAt(noun, frame));
        builder.addLine("rainTemperatureAt", WeatherState.getRainTemperatureAt(noun, frame));
        return builder.toString();
    }

    public static boolean isRainingOutside(Frame frame) {
        return WeatherState.get((Frame)frame).weatherProvider.isRainingAtHours(TimeState.getGameTimeElapsedHoursSinceDay0(frame));
    }

    public static Sentences getWeatherDescription(Frame frame) {
        boolean raining = WeatherState.isRainingOutside(frame);
        if (raining) {
            return Nlg.literalSentences("It is raining.");
        }
        return null;
    }

    public static FlexibleHeatUnit getAirTemperatureAt(Noun noun, Frame frame) {
        return WeatherState.get((Frame)frame).weatherProvider.getAirTemperatureAt(noun, frame);
    }

    public static FlexibleHeatUnit getRainTemperatureAt(Noun noun, Frame frame) {
        return FlexibleHeatUnit.create(RainEffectState.isRainingOn(noun, frame) ? -1.5 : 0.0);
    }

    public static FlexibleHeatUnit getSunTemperatureAt(Noun noun, Frame frame) {
        Double intensity = SunState.get(frame).getIntensityAt(noun, frame);
        return FlexibleHeatUnit.create((intensity - 0.2) * 2.0);
    }
}

