/*
 * Decompiled with CFR 0.152.
 */
package com.fabriziopolo.textcraft.states.water;

import com.fabriziopolo.textcraft.simulation.Frame;
import com.fabriziopolo.textcraft.simulation.Noun;
import com.fabriziopolo.textcraft.simulation.Simulation;
import com.fabriziopolo.textcraft.simulation.State;
import com.fabriziopolo.textcraft.states.ValueState;
import com.fabriziopolo.textcraft.states.ValueWithCauseState;
import com.fabriziopolo.textcraft.states.inventory.InventoryState;
import com.fabriziopolo.textcraft.states.position.PositionState;
import com.fabriziopolo.textcraft.states.temperature.FlexibleHeatUnit;
import com.fabriziopolo.textcraft.states.water.WaterStateBuilder;
import com.fabriziopolo.textcraft.states.weather.rain.RainEffectState;
import com.fabriziopolo.textcraft.text.DebugInfoBuilder;

public class WaterState
extends ValueState<Double> {
    private static final double WATER_TEMPERATURE_DELTA = -1.5;
    public static final double MAX_DEPTH = 1.0;
    public static final double MIN_DEPTH = 0.0;

    public static WaterState get(Frame frame) {
        return (WaterState)frame.states.get(WaterState.class);
    }

    public double getDepthAt(Noun noun, Frame frame) {
        Double depth = null;
        PositionState positionState = PositionState.get(frame);
        while (noun != null && (depth = (Double)this.get(noun)) == null) {
            noun = positionState.getParent(noun);
        }
        if (depth == null) {
            return 0.0;
        }
        return depth;
    }

    @Override
    protected Double combineValues(Noun noun, Double t1, Double t2, Simulation simulation) {
        return t1 + t2;
    }

    @Override
    protected Class getStateKey() {
        return WaterState.class;
    }

    @Override
    public State updateState(Simulation simulation) {
        WaterStateBuilder builder = WaterState.builder();
        this.setUpdatedState(simulation, builder);
        return builder.build();
    }

    @Override
    public String getDebugInfo(Noun noun, Frame frame) {
        DebugInfoBuilder builder = new DebugInfoBuilder(this.getStateKey());
        builder.addLine("depth", this.getDepthAt(noun, frame));
        builder.addLine("isInWater", WaterState.isInWater(noun, frame));
        builder.addLine("isSubmerged", WaterState.isSubmerged(noun, frame));
        builder.addLine("isWet", WaterState.isWet(noun, frame));
        return builder.toString();
    }

    public static WaterStateBuilder builder() {
        return new WaterStateBuilder();
    }

    public static void requestAddDepth(Noun roomNoun, double depth, Simulation simulation) {
        simulation.requestStateChange(WaterState.class, new ValueState.ChangeRequest<Double>(roomNoun, depth));
    }

    public static boolean isInWater(Noun noun, Frame frame) {
        noun = InventoryState.getLocation(noun, frame);
        double depth = WaterState.get(frame).getDepthAt(noun, frame);
        return depth > 0.0;
    }

    public static boolean isSubmerged(Noun noun, Frame frame) {
        noun = InventoryState.getLocation(noun, frame);
        double depth = WaterState.get(frame).getDepthAt(noun, frame);
        return depth >= 1.0;
    }

    public static ValueWithCauseState.ValueWithCause<Boolean> isWet(Noun noun, Frame frame) {
        if (WaterState.isSubmerged(noun = InventoryState.getLocation(noun, frame), frame)) {
            return ValueWithCauseState.ValueWithCause.create(true, "it is submerged in water");
        }
        if (WaterState.isInWater(noun, frame)) {
            return ValueWithCauseState.ValueWithCause.create(true, "it is in water");
        }
        if (RainEffectState.isRainingOn(noun, frame)) {
            return ValueWithCauseState.ValueWithCause.create(true, "the rain is making it wet");
        }
        return ValueWithCauseState.ValueWithCause.create(false);
    }

    public static FlexibleHeatUnit getWaterTemperatureAt(Noun noun, Frame frame) {
        if (!WaterState.isInWater(noun, frame)) {
            return FlexibleHeatUnit.createNeutral();
        }
        double depth = WaterState.get(frame).getDepthAt(noun, frame);
        if (depth > 0.5) {
            return FlexibleHeatUnit.create(-1.5, 0.0);
        }
        return FlexibleHeatUnit.create(-0.75, 0.375);
    }
}

