/*
 * Decompiled with CFR 0.152.
 */
package com.fabriziopolo.textcraft.states.updatable;

import com.fabriziopolo.textcraft.simulation.Noun;
import com.fabriziopolo.textcraft.simulation.Simulation;
import com.fabriziopolo.textcraft.states.time.TimeState;
import com.fabriziopolo.textcraft.states.updatable.Updateable;
import java.time.Duration;
import java.time.Instant;
import java.util.Objects;

public class PeriodicUpdatable
implements Updateable {
    private final Updateable delegate;
    private final Duration period;
    private final Duration offset;
    private Instant lastUpdate = null;

    public PeriodicUpdatable(Duration period, Updateable delegate) {
        this(period, null, delegate);
    }

    public PeriodicUpdatable(Duration period, Duration offset, Updateable delegate) {
        this.delegate = Objects.requireNonNull(delegate);
        this.period = Objects.requireNonNull(period);
        this.offset = offset == null ? Duration.ZERO : offset;
    }

    @Override
    public void update(Noun noun, Simulation simulation) {
        Instant now = TimeState.get(simulation.getCurrentFrame()).getGameTimeInstant();
        if (this.lastUpdate == null) {
            this.lastUpdate = now.minus(this.period).plus(this.offset);
        }
        if (this.period.minus(Duration.between(this.lastUpdate, now)).isNegative()) {
            this.lastUpdate = now;
            this.delegate.update(noun, simulation);
        }
    }
}

