/*
 * Decompiled with CFR 0.152.
 */
package com.fabriziopolo.textcraft.states.temperature;

import com.fabriziopolo.textcraft.text.Text;
import java.io.Serializable;

public final class FlexibleHeatUnit
implements Serializable {
    private final double generatedHeat;
    private final double positiveFlexibility;
    private final double negativeFlexibility;

    private FlexibleHeatUnit(double generatedHeat, double positiveFlexibility, double negativeFlexibility) {
        this.generatedHeat = generatedHeat;
        this.positiveFlexibility = positiveFlexibility;
        double d = this.negativeFlexibility = negativeFlexibility == 0.0 ? -0.0 : negativeFlexibility;
        if (positiveFlexibility < 0.0) {
            throw new IllegalArgumentException();
        }
        if (negativeFlexibility > 0.0) {
            throw new IllegalArgumentException();
        }
    }

    public double getValue() {
        return this.generatedHeat;
    }

    public double getFlexibleValue() {
        if (this.generatedHeat < 0.0) {
            if (this.generatedHeat + this.positiveFlexibility >= 0.0) {
                return 0.0;
            }
            return this.generatedHeat + this.positiveFlexibility;
        }
        if (this.generatedHeat + this.negativeFlexibility <= 0.0) {
            return 0.0;
        }
        return this.generatedHeat + this.negativeFlexibility;
    }

    public static FlexibleHeatUnit create(double generatedHeat) {
        return new FlexibleHeatUnit(generatedHeat, 0.0, 0.0);
    }

    public static FlexibleHeatUnit create(double generatedHeat, double flexibility) {
        return new FlexibleHeatUnit(generatedHeat, flexibility, -flexibility);
    }

    public static FlexibleHeatUnit createWithBounds(double flexibleLowerBound, double flexibleUpperBound) {
        double generatedHeat = (flexibleLowerBound + flexibleUpperBound) / 2.0;
        return new FlexibleHeatUnit(generatedHeat, flexibleUpperBound - generatedHeat, flexibleLowerBound - generatedHeat);
    }

    public static FlexibleHeatUnit createFlexible(double lowerFlexibility, double upperFlexibility) {
        if (lowerFlexibility > 0.0 || upperFlexibility < 0.0) {
            throw new IllegalArgumentException();
        }
        return new FlexibleHeatUnit(0.0, upperFlexibility, lowerFlexibility);
    }

    public static FlexibleHeatUnit create(double generatedHeat, double positiveFlexibility, double negativeFlexibility) {
        return new FlexibleHeatUnit(generatedHeat, positiveFlexibility, negativeFlexibility);
    }

    public FlexibleHeatUnit plus(FlexibleHeatUnit unit) {
        if (unit == null) {
            return this;
        }
        return new FlexibleHeatUnit(this.generatedHeat + unit.generatedHeat, this.positiveFlexibility + unit.positiveFlexibility, this.negativeFlexibility + unit.negativeFlexibility);
    }

    public FlexibleHeatUnit times(double multiplier) {
        return new FlexibleHeatUnit(this.generatedHeat * multiplier, this.positiveFlexibility * multiplier, this.negativeFlexibility * multiplier);
    }

    public FlexibleHeatUnit combineNeutrally(FlexibleHeatUnit other) {
        if (other == null) {
            return this;
        }
        return new FlexibleHeatUnit(Math.abs(this.generatedHeat) < Math.abs(other.generatedHeat) ? other.generatedHeat : this.generatedHeat, Math.min(this.positiveFlexibility, other.positiveFlexibility), Math.max(this.negativeFlexibility, other.negativeFlexibility));
    }

    public static FlexibleHeatUnit createNeutral() {
        return new FlexibleHeatUnit(0.0, 0.0, 0.0);
    }

    public String toString() {
        return "FlexibleHeatUnit(" + Text.displayValue(this.generatedHeat) + " +" + Text.displayValue(this.positiveFlexibility) + " -" + Text.displayValue(-this.negativeFlexibility) + ")" + "@(" + Text.displayValue(this.getFlexibleValue()) + ")";
    }
}

