/*
 * Decompiled with CFR 0.152.
 */
package com.fabriziopolo.textcraft.states.takeable;

import com.fabriziopolo.textcraft.events.notification.PlayerNotificationEvent;
import com.fabriziopolo.textcraft.nlg.NounPhrase;
import com.fabriziopolo.textcraft.nlg.NounPhraseWithArticle;
import com.fabriziopolo.textcraft.nlg.Pronouns;
import com.fabriziopolo.textcraft.player.Player;
import com.fabriziopolo.textcraft.simulation.Frame;
import com.fabriziopolo.textcraft.simulation.Noun;
import com.fabriziopolo.textcraft.simulation.Simulation;
import com.fabriziopolo.textcraft.simulation.perception.Perceiver;
import com.fabriziopolo.textcraft.states.position.PositionStateBuilder;
import com.fabriziopolo.textcraft.states.takeable.TakeHandler;
import java.util.List;

public class UntakeableTakeHandler
implements TakeHandler {
    public static final UntakeableTakeHandler defaultInstance = new UntakeableTakeHandler();
    private final String message;

    private UntakeableTakeHandler() {
        this.message = null;
    }

    public String toString() {
        return "UntakeableTakeHandler(\"" + this.message + "\")";
    }

    private UntakeableTakeHandler(String message) {
        this.message = message;
    }

    @Override
    public boolean isProducible(Player player, Noun nounToTake, Noun tool, Frame frame) {
        return false;
    }

    @Override
    public void onNotProducible(Player player, Noun nounToTake, Noun tool, Simulation simulation, PositionStateBuilder partialState) {
        PlayerNotificationEvent.post((Noun)player, simulation, this.getHint(player, nounToTake, simulation));
    }

    @Override
    public Noun willProduceOne(Player player, Noun nounToTake, Noun tool, Simulation simulation, PositionStateBuilder partialState) {
        throw new IllegalStateException("Cannot produce when isProducible() returns false.");
    }

    @Override
    public List<Noun> willProduce(Player player, Noun nounToTake, Noun tool, Simulation simulation, PositionStateBuilder partialState) {
        throw new IllegalStateException("Cannot produce when isProducible() returns false.");
    }

    @Override
    public void consume(Player player, List<Noun> nounsToTake, Noun tool, Simulation simulation, PositionStateBuilder partialState) {
        throw new IllegalStateException("Cannot consume when isProducible() returns false.");
    }

    public String getHint(Perceiver player, Noun nounToTake, Simulation simulation) {
        if (this.message != null) {
            return this.message;
        }
        NounPhrase nounDescription = player.getPerceptionOf(nounToTake, simulation.getCurrentFrame());
        if (nounDescription == null) {
            nounDescription = Pronouns.that;
        }
        return "You cannot take " + NounPhraseWithArticle.the(nounDescription) + ".";
    }

    public static UntakeableTakeHandler withMessage(String message) {
        return new UntakeableTakeHandler(message);
    }
}

