/*
 * Decompiled with CFR 0.152.
 */
package com.fabriziopolo.textcraft.states.takeable;

import com.fabriziopolo.textcraft.player.Player;
import com.fabriziopolo.textcraft.simulation.Frame;
import com.fabriziopolo.textcraft.simulation.Noun;
import com.fabriziopolo.textcraft.simulation.Simulation;
import com.fabriziopolo.textcraft.states.position.PositionStateBuilder;
import com.fabriziopolo.textcraft.states.structure.StructureState;
import com.fabriziopolo.textcraft.states.takeable.TakeHandler;
import java.util.List;
import java.util.stream.Collectors;

public class TakesContentsTakeHandler
implements TakeHandler {
    private final boolean removeObjectWhenEmpty;

    public TakesContentsTakeHandler(boolean removeObjectWhenEmpty) {
        this.removeObjectWhenEmpty = removeObjectWhenEmpty;
    }

    public static TakesContentsTakeHandler create() {
        return new TakesContentsTakeHandler(false);
    }

    public static TakesContentsTakeHandler createRemovingWhenEmpty() {
        return new TakesContentsTakeHandler(true);
    }

    @Override
    public boolean isProducible(Player player, Noun nounToTake, Noun tool, Frame frame) {
        return !this.getContents(nounToTake, frame).isEmpty();
    }

    @Override
    public Noun willProduceOne(Player player, Noun nounToTake, Noun tool, Simulation simulation, PositionStateBuilder partialState) {
        Frame frame = simulation.getCurrentFrame();
        List<Noun> contents = this.getContents(nounToTake, frame);
        if (contents.isEmpty()) {
            return null;
        }
        return contents.get(0);
    }

    @Override
    public void doProduce(Player player, Noun originalNounToTake, List<Noun> producedNouns, Noun tool, Simulation simulation, PositionStateBuilder partialState) {
        Frame frame = simulation.getCurrentFrame();
        List<Noun> contents = this.getContents(originalNounToTake, frame);
        if (this.removeObjectWhenEmpty && contents.size() == 1) {
            partialState.disconnect(originalNounToTake);
        }
        producedNouns.forEach(product -> partialState.disconnect((Noun)product));
    }

    private List<Noun> getContents(Noun nounToTake, Frame frame) {
        return StructureState.getNonintegralChildren(nounToTake, frame).stream().collect(Collectors.toList());
    }
}

