/*
 * Decompiled with CFR 0.152.
 */
package com.fabriziopolo.textcraft.states.scenery;

import com.fabriziopolo.textcraft.nlg.IndependentClause;
import com.fabriziopolo.textcraft.simulation.Frame;
import com.fabriziopolo.textcraft.simulation.Noun;
import com.fabriziopolo.textcraft.simulation.perception.Perceiver;
import com.fabriziopolo.textcraft.simulation.perception.PerceptionChannel;
import com.fabriziopolo.textcraft.states.coordinate.CoordinateState;
import com.fabriziopolo.textcraft.states.coordinate.Coordinates;
import com.fabriziopolo.textcraft.states.scenery.Scenery;

public class BandedScenery
implements Scenery {
    private final double nearest;
    private final double farthest;
    private final String frontDirection;
    private final Scenery delegate;

    public BandedScenery(double nearest, double farthest, String frontDirection, Scenery delegate) {
        this.nearest = nearest;
        this.farthest = farthest;
        this.frontDirection = frontDirection;
        this.delegate = delegate;
    }

    @Override
    public IndependentClause asPerceivedBy(Perceiver perceiver, Noun direction, Noun associatedNoun, PerceptionChannel channel, Frame frame) {
        String directionString = direction.getContextFreeDescription().toString();
        if (!directionString.equals(this.frontDirection)) {
            return null;
        }
        Coordinates perceiverCoordinates = CoordinateState.get(perceiver, frame);
        Coordinates sceneryCoordinates = CoordinateState.get(associatedNoun, frame);
        if (perceiverCoordinates == null || sceneryCoordinates == null) {
            return null;
        }
        if (perceiverCoordinates.distanceTo(sceneryCoordinates) < 2.0) {
            return null;
        }
        double yDiff = sceneryCoordinates.y - perceiverCoordinates.y;
        double xDiff = sceneryCoordinates.x - perceiverCoordinates.x;
        boolean isVisible = false;
        switch (this.frontDirection) {
            case "north": {
                isVisible = -yDiff >= this.nearest && -yDiff <= this.farthest;
                break;
            }
            case "south": {
                isVisible = yDiff >= this.nearest && yDiff <= this.farthest;
                break;
            }
            case "east": {
                isVisible = xDiff >= this.nearest && xDiff <= this.farthest;
                break;
            }
            case "west": {
                isVisible = -xDiff >= this.nearest && -xDiff <= this.farthest;
                break;
            }
            default: {
                throw new RuntimeException("Unsupported direction.");
            }
        }
        return isVisible ? this.delegate.asPerceivedBy(perceiver, direction, associatedNoun, channel, frame) : null;
    }

    @Override
    public double getPerceivedDistance(Noun noun1, Noun noun2, Frame frame) {
        Coordinates coord1 = CoordinateState.get(noun1, frame);
        Coordinates coord2 = CoordinateState.get(noun2, frame);
        switch (this.frontDirection) {
            case "north": {
                return Math.abs(coord1.y - coord2.y);
            }
            case "south": {
                return Math.abs(coord1.y - coord2.y);
            }
            case "east": {
                return Math.abs(coord1.x - coord2.x);
            }
            case "west": {
                return Math.abs(coord1.x - coord2.x);
            }
        }
        throw new RuntimeException("Unsupported direction.");
    }
}

