/*
 * Decompiled with CFR 0.152.
 */
package com.fabriziopolo.textcraft.states.position;

import com.fabriziopolo.textcraft.nlg.Preposition;
import com.fabriziopolo.textcraft.player.Player;
import com.fabriziopolo.textcraft.simulation.Frame;
import com.fabriziopolo.textcraft.simulation.Noun;
import com.fabriziopolo.textcraft.simulation.Simulation;
import com.fabriziopolo.textcraft.simulation.State;
import com.fabriziopolo.textcraft.simulation.StateChangeRequest;
import com.fabriziopolo.textcraft.states.position.PathSegment;
import com.fabriziopolo.textcraft.states.position.PositionStateBuilder;
import com.fabriziopolo.textcraft.states.position.PositionUpdateRequest;
import com.fabriziopolo.textcraft.states.position.PutEntranceRequest;
import com.fabriziopolo.textcraft.states.position.PutExitRequest;
import com.fabriziopolo.textcraft.states.position.RoomExitLink;
import com.fabriziopolo.textcraft.states.position.SpacialRelationship;
import com.fabriziopolo.textcraft.states.position.updates.GoPrepositionUpdateRequest;
import com.fabriziopolo.textcraft.states.position.updates.PlayerPutsNounRequest;
import com.fabriziopolo.textcraft.states.position.updates.PositionRemoveObjectsRequest;
import com.fabriziopolo.textcraft.states.position.updates.PutRequest;
import com.fabriziopolo.textcraft.text.DebugInfoBuilder;
import com.fabriziopolo.textcraft.text.Text;
import com.fabriziopolo.textcraft.utils.Lockable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.BiPredicate;

public class PositionState
extends Lockable
implements State {
    protected final Map<Noun, Noun> parents = new HashMap<Noun, Noun>();
    protected final Map<Noun, Set<Noun>> children = new HashMap<Noun, Set<Noun>>();
    protected Map<Noun, Preposition> prepositionMap = new HashMap<Noun, Preposition>();
    protected Map<Noun, Preposition> reversePrepositionMap = new HashMap<Noun, Preposition>();
    protected final Map<Noun, Map<SpacialRelationship, RoomExitLink>> exitMap = new HashMap<Noun, Map<SpacialRelationship, RoomExitLink>>();
    protected final Map<Noun, Map<SpacialRelationship, Noun>> entranceMap = new HashMap<Noun, Map<SpacialRelationship, Noun>>();

    public static PositionState get(Frame frame) {
        return (PositionState)Objects.requireNonNull(frame).states.get(PositionState.class);
    }

    public static PositionStateBuilder builder() {
        return new PositionStateBuilder();
    }

    public static PositionStateBuilder builder(PositionState copyMe) {
        return new PositionStateBuilder(copyMe);
    }

    public Noun getParent(Noun obj) {
        return this.parents.get(obj);
    }

    public Set<Noun> getChildren(Noun obj) {
        return this.children.get(obj);
    }

    public Preposition getPreposition(Noun noun) {
        return this.prepositionMap.get(noun);
    }

    public Preposition getReversePreposition(Noun noun) {
        return this.reversePrepositionMap.get(noun);
    }

    public Preposition getPreposition(Noun noun, Noun ancestor) {
        Noun currNoun = noun;
        while (currNoun != null) {
            Noun parent = this.getParent(currNoun);
            if (parent == ancestor) {
                return this.getPreposition(currNoun);
            }
            currNoun = parent;
        }
        throw new IllegalArgumentException("getPreposition(Noun noun, Noun ancestor, Frame frame) with ancestor not an ancestor of noun.");
    }

    public Map<SpacialRelationship, PathSegment> getExits(Noun room) {
        Map<SpacialRelationship, RoomExitLink> nounSegmentExitLinkMap = this.exitMap.get(room);
        if (nounSegmentExitLinkMap == null) {
            return new HashMap<SpacialRelationship, PathSegment>();
        }
        HashMap<SpacialRelationship, PathSegment> segments = new HashMap<SpacialRelationship, PathSegment>();
        nounSegmentExitLinkMap.forEach((direction, exitLink) -> segments.put((SpacialRelationship)direction, this.exitLinkToPathSegment(room, (SpacialRelationship)direction, (RoomExitLink)exitLink)));
        return segments;
    }

    public PathSegment getExit(Noun room, SpacialRelationship direction) {
        Map<SpacialRelationship, RoomExitLink> nounSegmentExitLinkMap = this.exitMap.get(room);
        if (nounSegmentExitLinkMap == null || !nounSegmentExitLinkMap.containsKey(direction)) {
            return null;
        }
        return this.exitLinkToPathSegment(room, direction, nounSegmentExitLinkMap.get(direction));
    }

    public Map<SpacialRelationship, Noun> getEntrances(Noun room) {
        return this.entranceMap.get(room);
    }

    public Noun getEntrance(Noun room, SpacialRelationship dir) {
        Map<SpacialRelationship, Noun> map = this.entranceMap.get(room);
        if (map == null) {
            return null;
        }
        return map.get(dir);
    }

    @Override
    public State updateState(Simulation simulation) {
        List<PositionUpdateRequest> reqs = this.getRequests(simulation);
        PositionStateBuilder partialState = PositionState.builder(this);
        for (PositionUpdateRequest req : reqs) {
            req.apply(partialState, simulation);
        }
        return partialState.build();
    }

    @Override
    public String getDebugInfo(Noun noun, Frame frame) {
        DebugInfoBuilder builder = new DebugInfoBuilder(PositionState.class);
        builder.addLine("parent", this.getParent(noun));
        builder.addLine("preposition", this.getPreposition(noun));
        builder.addLine("children", this.getChildren(noun));
        builder.addLine("exits", this.getExits(noun));
        builder.addLine("entrances", this.getEntrances(noun));
        builder.addLine("scene graph", this.getDebugChildTree(noun, frame));
        return builder.toString();
    }

    public String getDebugChildTree(Noun noun, Frame frame) {
        StringBuilder builder = new StringBuilder();
        this.buildDebugChildTree(noun, 2, frame, builder);
        return builder.toString();
    }

    private void buildDebugChildTree(Noun noun, int depth, Frame frame, StringBuilder builder) {
        builder.append(Text.getLineSeparator());
        for (int i = 0; i < depth; ++i) {
            builder.append("  ");
        }
        builder.append(noun.getDefaultPerception(frame));
        PositionState positionState = PositionState.get(frame);
        Preposition preposition = positionState.getPreposition(noun);
        if (preposition != null) {
            builder.append(" (" + preposition);
            Preposition reversePreposition = positionState.getReversePreposition(noun);
            if (reversePreposition != null) {
                builder.append(", " + reversePreposition);
            }
            builder.append(")");
        }
        builder.append("  #" + noun.hashCode());
        Set<Noun> children = positionState.getChildren(noun);
        if (children == null) {
            return;
        }
        for (Noun child : children) {
            this.buildDebugChildTree(child, depth + 1, frame, builder);
        }
    }

    public Noun getContainingRoom(Noun noun) {
        Noun parent = this.getParent(noun);
        if (parent == null) {
            return noun;
        }
        return this.getContainingRoom(parent);
    }

    public Noun getParentSatisfying(Noun noun, BiPredicate<Noun, Preposition> predicate) {
        if (noun == null) {
            return null;
        }
        if (predicate.test(noun, null)) {
            return noun;
        }
        return this.getParentSatisfying(noun, this.getPreposition(noun), predicate);
    }

    public Set<Noun> getDesendentsOf(Noun noun) {
        HashSet<Noun> descendents = new HashSet<Noun>();
        this.accumulateDescendentsOf(noun, descendents);
        return descendents;
    }

    public List<PathSegment> getPathFromExterior(Noun noun) {
        ArrayList<PathSegment> path = new ArrayList<PathSegment>();
        SpacialRelationship prevDir = null;
        while (true) {
            SpacialRelationship nextDir = SpacialRelationship.ofOrNull(this.getPreposition(noun));
            Noun parent = this.getParent(noun);
            if (parent == null) break;
            Noun exit = null;
            SpacialRelationship exitDir = nextDir;
            SpacialRelationship entranceDir = SpacialRelationship.ofOrNull(this.getReversePreposition(noun));
            path.add(new PathSegment(parent, exitDir, exit, this.getEntrance(noun, prevDir), entranceDir, noun, PathSegment.Pointing.IN));
            prevDir = nextDir;
            noun = parent;
        }
        Collections.reverse(path);
        return path;
    }

    public List<PathSegment> getPathToExterior(Noun noun) {
        Noun parent;
        ArrayList<PathSegment> path = new ArrayList<PathSegment>();
        while ((parent = this.getParent(noun)) != null) {
            SpacialRelationship entranceDir = SpacialRelationship.ofOrNull(this.getPreposition(noun));
            Noun entrance = this.getEntrance(parent, entranceDir);
            SpacialRelationship exitDir = SpacialRelationship.ofOrNull(this.getReversePreposition(noun));
            Noun exit = null;
            path.add(new PathSegment(noun, exitDir, exit, entrance, entranceDir, parent, PathSegment.Pointing.OUT));
            noun = parent;
        }
        return path;
    }

    public List<PathSegment> getPathBetween(Noun startNoun, Noun endNoun) {
        int i;
        if (startNoun == endNoun) {
            return new ArrayList<PathSegment>();
        }
        Noun room = this.getContainingRoom(startNoun);
        if (this.getContainingRoom(endNoun) != room) {
            return new ArrayList<PathSegment>();
        }
        List<PathSegment> outPath = this.getPathToExterior(startNoun);
        List<PathSegment> inPath = this.getPathFromExterior(endNoun);
        if (outPath.isEmpty()) {
            return inPath;
        }
        if (inPath.isEmpty()) {
            return outPath;
        }
        int outIdx = outPath.size() - 1;
        int inIdx = 0;
        Noun joinNoun = null;
        while (outPath.get((int)outIdx).endNoun == inPath.get((int)inIdx).startNoun) {
            joinNoun = outPath.get((int)outIdx).startNoun == inPath.get((int)inIdx).endNoun ? outPath.get((int)outIdx).startNoun : outPath.get((int)outIdx).endNoun;
            if (--outIdx >= 0 && ++inIdx < inPath.size()) continue;
        }
        if (joinNoun == null) {
            throw new IllegalStateException("Two objects in the same room MUST have a common intersection above them.  Implementation error.");
        }
        ArrayList<PathSegment> path = new ArrayList<PathSegment>();
        for (PathSegment segment : outPath) {
            if (segment.startNoun == joinNoun) break;
            path.add(segment);
            if (segment.endNoun != joinNoun) continue;
            break;
        }
        ArrayList<PathSegment> reverseInPath = new ArrayList<PathSegment>();
        for (i = inPath.size() - 1; i >= 0; --i) {
            PathSegment segment = inPath.get(i);
            if (segment.endNoun == joinNoun) break;
            reverseInPath.add(segment);
            if (segment.startNoun == joinNoun) break;
        }
        PositionState.clipTurnaroundEntranceAndExit(path, reverseInPath);
        for (i = reverseInPath.size() - 1; i >= 0; --i) {
            path.add((PathSegment)reverseInPath.get(i));
        }
        return path;
    }

    private static void clipTurnaroundEntranceAndExit(List<PathSegment> path, List<PathSegment> reversePath) {
        if (path.isEmpty() || reversePath.isEmpty()) {
            return;
        }
        PathSegment entrySegment = path.get(path.size() - 1);
        PathSegment exitSegment = reversePath.get(reversePath.size() - 1);
        if (!entrySegment.entranceDirection.equals(exitSegment.exitDirection)) {
            return;
        }
        PathSegment newEntrySegment = new PathSegment(entrySegment.startNoun, entrySegment.exitDirection, entrySegment.exit, null, entrySegment.entranceDirection, entrySegment.endNoun, entrySegment.pointing);
        PathSegment newExitSegment = new PathSegment(exitSegment.startNoun, exitSegment.exitDirection, null, exitSegment.entrance, exitSegment.entranceDirection, exitSegment.endNoun, exitSegment.pointing);
        path.set(path.size() - 1, newEntrySegment);
        reversePath.set(reversePath.size() - 1, newExitSegment);
    }

    public List<PathSegment> getPathBetweenNounsInDifferentRooms(Noun startNoun, SpacialRelationship direction, Noun endNoun) {
        List<PathSegment> outPath = this.getPathToExterior(startNoun);
        Noun roomContainingEndNoun = this.getContainingRoom(endNoun);
        PathSegment exitSegment = this.getExit(roomContainingEndNoun, direction);
        List<PathSegment> inPath = this.getPathFromExterior(endNoun);
        if (exitSegment.endNoun != roomContainingEndNoun) {
            throw new IllegalArgumentException("getPathBetweenNounsInDifferentRooms() for disconnected nouns.");
        }
        ArrayList<PathSegment> path = new ArrayList<PathSegment>();
        path.addAll(outPath);
        path.add(exitSegment);
        path.addAll(inPath);
        return path;
    }

    private Noun getParentSatisfying(Noun noun, Preposition prevPreposition, BiPredicate<Noun, Preposition> predicate) {
        if (noun == null) {
            return null;
        }
        if (predicate.test(noun, prevPreposition)) {
            return noun;
        }
        return this.getParentSatisfying(this.getParent(noun), this.getPreposition(noun), predicate);
    }

    private void accumulateDescendentsOf(Noun noun, Set<Noun> descendents) {
        Set<Noun> childrenOfNoun = this.children.get(noun);
        if (childrenOfNoun == null) {
            return;
        }
        for (Noun child : childrenOfNoun) {
            descendents.add(child);
            this.accumulateDescendentsOf(child, descendents);
        }
    }

    private List<PositionUpdateRequest> getRequests(Simulation simulation) {
        List<StateChangeRequest> requests = simulation.getStateChangeRequests(PositionState.class);
        if (requests == null) {
            return new ArrayList<PositionUpdateRequest>();
        }
        ArrayList<PositionUpdateRequest> positionUpdateRequests = new ArrayList<PositionUpdateRequest>();
        for (StateChangeRequest req : requests) {
            positionUpdateRequests.add((PositionUpdateRequest)req);
        }
        return positionUpdateRequests;
    }

    private PathSegment exitLinkToPathSegment(Noun room, SpacialRelationship direction, RoomExitLink exitLink) {
        Noun entrance = null;
        Map<SpacialRelationship, Noun> directionEntranceMap = this.entranceMap.get(exitLink.targetRoom);
        if (directionEntranceMap != null) {
            entrance = directionEntranceMap.get(exitLink.entranceDirection);
        }
        return new PathSegment(room, direction, exitLink.exit, entrance, exitLink.entranceDirection, exitLink.targetRoom, PathSegment.Pointing.HORIZONTALLY);
    }

    public static void requestRemove(Noun noun, Simulation simulation) {
        simulation.requestStateChange(PositionState.class, new PositionRemoveObjectsRequest(noun));
    }

    public static void requestPut(Noun noun, Preposition preposition, Preposition reversePreposition, Noun spot, Simulation simulation) {
        simulation.requestStateChange(PositionState.class, new PutRequest(noun, preposition, reversePreposition, spot));
    }

    public static void requestPlayerPut(Player player, Noun noun, Preposition preposition, Noun spot, Simulation simulation) {
        simulation.requestStateChange(PositionState.class, new PlayerPutsNounRequest(player, noun, preposition, spot));
    }

    public static void requestPlayerDrop(Player player, Noun noun, Preposition preposition, Noun spot, Simulation simulation) {
        simulation.requestStateChange(PositionState.class, new PlayerPutsNounRequest("drop", player, noun, preposition, spot));
    }

    public static void requestPutExit(Noun noun, SpacialRelationship direction, RoomExitLink exitLink, Simulation simulation) {
        simulation.requestStateChange(PositionState.class, new PutExitRequest(noun, direction, exitLink));
    }

    public static void requestPutEntrance(Noun noun, SpacialRelationship spacialRelationship, Noun entranceNoun, Simulation simulation) {
        simulation.requestStateChange(PositionState.class, new PutEntranceRequest(noun, spacialRelationship, entranceNoun));
    }

    public static void requestGo(Noun goer, Preposition preposition, Preposition reversePreposition, Simulation simulation, Noun spot) {
        simulation.requestStateChange(PositionState.class, new GoPrepositionUpdateRequest(goer, preposition, reversePreposition, simulation, spot));
    }
}

