/*
 * Decompiled with CFR 0.152.
 */
package com.fabriziopolo.textcraft.states.inventory;

import com.fabriziopolo.textcraft.simulation.Noun;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

public class Inventory
implements Serializable {
    private final Noun owner;
    private final List<Noun> items;

    private Inventory(Builder builder) {
        this.owner = Objects.requireNonNull(builder.owner);
        this.items = Objects.requireNonNull(builder.items);
    }

    public List<Noun> getItems() {
        return new ArrayList<Noun>(this.items);
    }

    public Noun getOwner() {
        return this.owner;
    }

    public static Inventory createEmpty(Noun owner) {
        return Inventory.builder(owner).build();
    }

    public static Builder builder(Noun owner) {
        return new Builder(owner);
    }

    public static Builder builder(Inventory inventory) {
        return new Builder(inventory);
    }

    public String toString() {
        return this.items.toString();
    }

    public static class Builder {
        private final Noun owner;
        private final List<Noun> items = new ArrayList<Noun>();

        private Builder(Noun owner) {
            this.owner = owner;
        }

        private Builder(Inventory inventory) {
            this.owner = inventory.owner;
            this.items.addAll(inventory.items);
        }

        public Builder addItem(Noun item) {
            this.items.add(item);
            return this;
        }

        public Builder removeItem(Noun item) {
            this.items.remove(item);
            return this;
        }

        public Inventory build() {
            return new Inventory(this);
        }
    }
}

