/*
 * Decompiled with CFR 0.152.
 */
package com.fabriziopolo.textcraft.states.edibility;

import com.fabriziopolo.textcraft.nlg.IndependentClause;
import com.fabriziopolo.textcraft.simulation.Noun;
import com.fabriziopolo.textcraft.simulation.Simulation;
import com.fabriziopolo.textcraft.states.edibility.EdibleEffect;
import com.fabriziopolo.textcraft.states.inventory.InventoryState;
import com.fabriziopolo.textcraft.states.position.PositionState;
import java.util.ArrayList;
import java.util.List;

public class AddIventoryItemsEdibleEffect
implements EdibleEffect {
    private final EdibleEffect delegateEffect;
    private final List<Noun> nounsToProduce;

    public AddIventoryItemsEdibleEffect(EdibleEffect delegateEffect, List<Noun> nounsToProduce) {
        this.delegateEffect = delegateEffect;
        this.nounsToProduce = nounsToProduce;
    }

    public AddIventoryItemsEdibleEffect(EdibleEffect delegateEffect, Noun nounToProduce) {
        this.delegateEffect = delegateEffect;
        this.nounsToProduce = new ArrayList<Noun>();
        this.nounsToProduce.add(nounToProduce);
    }

    @Override
    public void onConsumption(Simulation simulation, Noun consumer, Noun consumed, IndependentClause cause) {
        if (this.delegateEffect != null) {
            this.delegateEffect.onConsumption(simulation, consumer, consumed, cause);
        }
        this.nounsToProduce.forEach(noun -> {
            PositionState.requestRemove(noun, simulation);
            InventoryState.requestAddItem(consumer, noun, simulation);
        });
    }
}

