/*
 * Decompiled with CFR 0.152.
 */
package com.fabriziopolo.textcraft.states.coordinate;

import com.fabriziopolo.textcraft.simulation.Frame;
import com.fabriziopolo.textcraft.simulation.Noun;
import com.fabriziopolo.textcraft.simulation.Simulation;
import com.fabriziopolo.textcraft.simulation.State;
import com.fabriziopolo.textcraft.states.ValueState;
import com.fabriziopolo.textcraft.states.coordinate.Coordinates;
import com.fabriziopolo.textcraft.states.position.PositionState;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class CoordinateState
extends ValueState<Coordinates> {
    private final Map<Coordinates, Noun> roomFromCoordinatesMap = new ConcurrentHashMap<Coordinates, Noun>();

    @Override
    protected Class getStateKey() {
        return CoordinateState.class;
    }

    @Override
    public State updateState(Simulation simulation) {
        CoordinateState builder = new CoordinateState();
        this.setUpdatedState(simulation, builder);
        PositionState positionState = PositionState.get(simulation.getCurrentFrame());
        builder.getValueMap().forEach((noun, coord) -> builder.roomFromCoordinatesMap.put((Coordinates)coord, positionState.getContainingRoom((Noun)noun)));
        builder.setImmutable();
        return builder;
    }

    public Noun getRoomAt(double x, double y) {
        return this.roomFromCoordinatesMap.get(new Coordinates(x, y));
    }

    public static Coordinates get(Noun noun, Frame frame) {
        CoordinateState coordinateState = CoordinateState.get(frame);
        Noun parentWithCoords = PositionState.get(frame).getParentSatisfying(noun, (parent, preposition) -> coordinateState.getValueMap().containsKey(parent));
        if (parentWithCoords == null) {
            return null;
        }
        return (Coordinates)coordinateState.get(parentWithCoords);
    }

    public static double getDistanceBetween(Noun noun1, Noun noun2, Frame frame) {
        return Coordinates.distanceBetwween(CoordinateState.get(noun1, frame), CoordinateState.get(noun2, frame));
    }

    public static CoordinateState get(Frame frame) {
        return (CoordinateState)frame.states.get(CoordinateState.class);
    }

    public static void reqeustPut(Noun noun, Coordinates coordinates, Simulation simulation) {
        simulation.requestStateChange(CoordinateState.class, new ValueState.ChangeRequest<Coordinates>(noun, coordinates));
    }
}

