/*
 * Decompiled with CFR 0.152.
 */
package com.fabriziopolo.textcraft.states;

import com.fabriziopolo.textcraft.simulation.Frame;
import com.fabriziopolo.textcraft.simulation.Noun;
import com.fabriziopolo.textcraft.simulation.Simulation;
import com.fabriziopolo.textcraft.simulation.StateChangeRequest;
import com.fabriziopolo.textcraft.states.ValueState;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public abstract class MapState<K, V>
extends ValueState<HashMap<K, V>> {
    protected V combinePureValues(Noun noun, V t1, V t2, Frame frame) {
        return t2;
    }

    protected void applyUpdateRequestSideEffect(Noun noun, K key, V value, Simulation simulation) {
    }

    public V get(Noun noun, K key) {
        HashMap map = (HashMap)this.get(noun);
        if (map == null) {
            return null;
        }
        return map.get(key);
    }

    protected void put(Noun noun, K key, V value) {
        this.getOrCreateMap(noun).put(key, value);
    }

    protected HashMap<K, V> getOrCreateMap(Noun noun) {
        HashMap map = (HashMap)this.get(noun);
        if (map != null) {
            return map;
        }
        map = new HashMap();
        this.set(noun, map);
        return map;
    }

    protected void clonseStateToBuilder(MapState<K, V> builder) {
        this.getValueMap().forEach((noun, map) -> builder.getOrCreateMap((Noun)noun).putAll((Map)map));
    }

    protected void setUpdatedState(Simulation simulation, MapState<K, V> builder) {
        this.clonseStateToBuilder(builder);
        builder.applyUpdates(simulation);
    }

    @Override
    protected void applyUpdates(Simulation simulation) {
        this.requireMutable();
        Frame currentFrame = simulation.getCurrentFrame();
        List<StateChangeRequest> stateChangeRequests = simulation.getStateChangeRequests(this.getStateKey());
        if (stateChangeRequests != null) {
            stateChangeRequests.forEach(object -> {
                ChangeRequest req = (ChangeRequest)object;
                Object currentValue = req.value;
                if (currentValue == null) {
                    this.put(req.noun, req.key, req.value);
                } else {
                    this.put(req.noun, req.key, this.combinePureValues(req.noun, currentValue, req.value, currentFrame));
                    this.applyUpdateRequestSideEffect(req.noun, req.key, req.value, simulation);
                }
            });
        }
    }

    public static class ChangeRequest<K, V>
    implements StateChangeRequest {
        public final Noun noun;
        public final K key;
        public final V value;

        public ChangeRequest(Noun noun, K key, V value) {
            this.noun = Objects.requireNonNull(noun);
            this.key = Objects.requireNonNull(key);
            this.value = Objects.requireNonNull(value);
        }
    }
}

