/*
 * Decompiled with CFR 0.152.
 */
package com.fabriziopolo.textcraft.player;

import com.fabriziopolo.textcraft.simulation.Frame;
import com.fabriziopolo.textcraft.simulation.Noun;
import com.fabriziopolo.textcraft.states.inventory.InventoryState;
import com.fabriziopolo.textcraft.states.shade.LightFilter;
import com.fabriziopolo.textcraft.states.shade.ShadeState;
import com.fabriziopolo.textcraft.states.wearabililty.WearableCategory;
import java.util.Map;
import java.util.Objects;

public class WornItemLightFilter
implements LightFilter {
    private final Noun player;

    public WornItemLightFilter(Noun player) {
        this.player = Objects.requireNonNull(player);
    }

    @Override
    public double filterLight(double intensity, Frame frame) {
        Map<WearableCategory, Noun> wornItemsMap = InventoryState.getWornItemsMap(this.player, frame);
        if (wornItemsMap == null) {
            return intensity;
        }
        ShadeState shadeState = ShadeState.get(frame);
        for (Noun wornItem : wornItemsMap.values()) {
            LightFilter filter = shadeState.getLightFilter(wornItem);
            if (filter == null) continue;
            intensity = filter.filterLight(intensity, frame);
        }
        return intensity;
    }
}

