/*
 * Decompiled with CFR 0.152.
 */
package com.fabriziopolo.textcraft.player;

import com.fabriziopolo.textcraft.nlg.IndependentClause;
import com.fabriziopolo.textcraft.nlg.Nlg;
import com.fabriziopolo.textcraft.simulation.Noun;
import com.fabriziopolo.textcraft.simulation.Simulation;
import com.fabriziopolo.textcraft.states.characterbio.CharacterBioEffect;
import com.fabriziopolo.textcraft.states.notification.Notification;
import com.fabriziopolo.textcraft.states.notification.NotificationKey;
import com.fabriziopolo.textcraft.states.notification.NotificationState;
import com.fabriziopolo.textcraft.states.temperature.FlexibleHeatUnit;
import com.fabriziopolo.textcraft.states.temperature.TemperatureEffect;
import com.fabriziopolo.textcraft.states.temperature.TemperatureState;

public class PlayerTemperatureEffect
implements TemperatureEffect {
    private final NotificationKey temperatureChangeNotificationKey = new NotificationKey(PlayerTemperatureEffect.class);
    private static final double MAX_COMFORTABLE_TEMPERATURE_ABS = 1.0;
    private static final double MIN_DAMAGE_TEMPERATURE_ABS = 4.0;
    private static final double COLD_ENERGY_RATE = -0.5;
    private static final double COLD_FOOD_RATE = -0.5;
    private static final double COLD_DAMAGE_RATE = -2.0;
    private static final double HOT_HYDRATION_RATE = -0.5;
    private static final double HOT_DAMAGE_RATE = -0.5;
    private static final double TEMPERATURE_MAINTENANCE_FOOD_COST = -0.3;
    private CharacterBioEffect lastEffect = CharacterBioEffect.builder().build();

    @Override
    public void onTemperature(Noun noun, FlexibleHeatUnit heatUnit, Simulation simulation) {
        double temp = heatUnit.getFlexibleValue();
        CharacterBioEffect.dayTimeScaleBuilder(simulation).addFood(-0.3).build().apply(simulation, noun, null);
        CharacterBioEffect.Builder temperatureEffect = CharacterBioEffect.builder();
        IndependentClause cause = null;
        if (temp < -1.0) {
            cause = this.buildEffectWhenCold(noun, temp, temperatureEffect, simulation);
        } else if (temp > 1.0) {
            cause = this.buildEffectWhenHot(noun, temp, temperatureEffect, simulation);
        }
        this.applyEffect(noun, temperatureEffect, cause, simulation, false);
    }

    private IndependentClause buildEffectWhenCold(Noun noun, double temp, CharacterBioEffect.Builder temperatureEffect, Simulation simulation) {
        NotificationState.post(simulation, Notification.builder(noun, this.temperatureChangeNotificationKey).setMessage("You are " + TemperatureState.getTemperatureDescription(temp) + ".").build());
        double x = -temp - 1.0;
        double y = -temp - 4.0;
        if (x > 0.0) {
            temperatureEffect.addEnergy(x * -0.5).addFood(x * -0.5);
        }
        if (y > 0.0) {
            temperatureEffect.addHealth(y * -2.0);
        }
        return Nlg.literalClause("you are too cold");
    }

    private IndependentClause buildEffectWhenHot(Noun noun, double temp, CharacterBioEffect.Builder temperatureEffect, Simulation simulation) {
        NotificationState.post(simulation, Notification.builder(noun, this.temperatureChangeNotificationKey).setMessage("You are " + TemperatureState.getTemperatureDescription(temp) + ".").build());
        double x = temp - 1.0;
        double y = temp - 4.0;
        if (x > 0.0) {
            temperatureEffect.addHydration(x * -0.5);
        }
        if (y > 0.0) {
            temperatureEffect.addHealth(y * -0.5);
        }
        return Nlg.literalClause("you are too hot");
    }

    private void applyEffect(Noun player, CharacterBioEffect.Builder effectBuilder, IndependentClause independentClause, Simulation simulation, boolean notifyOfChange) {
        this.lastEffect = effectBuilder.build();
        effectBuilder.scaleBy(simulation.getUpdateParameters().getDeltaForRatePerDay(1.0));
        effectBuilder.build().apply(simulation, player, independentClause, notifyOfChange);
    }

    public String toString() {
        return this.lastEffect.toString();
    }
}

