/*
 * Decompiled with CFR 0.152.
 */
package com.fabriziopolo.textcraft.peristence;

import com.fabriziopolo.textcraft.app.Game;
import com.fabriziopolo.textcraft.app.SinglePlayerGameState;
import com.fabriziopolo.textcraft.peristence.Campaign;
import com.fabriziopolo.textcraft.peristence.Persistence;
import com.fabriziopolo.textcraft.simulation.Frame;
import com.fabriziopolo.textcraft.simulation.SinglePlayerSimulation;
import com.fabriziopolo.textcraft.states.singleplayer.RequestSaveGameState;
import com.fabriziopolo.textcraft.states.time.TimeState;
import com.fabriziopolo.textcraft.text.Text;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.PrintWriter;
import java.io.Serializable;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;

public class LocalAppStoragePersistence
implements Persistence {
    private static final String LOG_FILE_NAME = "textcraft-log.txt";
    private static final String SAVE_FILE_EXTENSION = ".sav";
    private final Game game;
    private final String versionedGameName;

    public LocalAppStoragePersistence(Game game) {
        this.game = Objects.requireNonNull(game);
        this.versionedGameName = LocalAppStoragePersistence.encodeString(Objects.requireNonNull(game.getEpisodeNameWithVersion()));
    }

    @Override
    public SinglePlayerGameState loadSinglePlayer(File file) throws IOException, ClassNotFoundException {
        FileInputStream inputFileStream = new FileInputStream(file);
        ObjectInputStream objectInputStream = new ObjectInputStream(inputFileStream);
        SinglePlayerGameState gameState = (SinglePlayerGameState)objectInputStream.readObject();
        objectInputStream.close();
        inputFileStream.close();
        return gameState;
    }

    @Override
    public List<File> getSaveGameFilesForCampaign(Campaign campaign) {
        this.createSaveGameFolders(campaign);
        File[] files = new File(this.getSaveGamePath(campaign)).listFiles();
        return Arrays.stream(files).filter(file -> file.getName().endsWith(SAVE_FILE_EXTENSION)).filter(file -> file.isFile()).sorted((f1, f2) -> -f1.getName().compareTo(f2.getName())).collect(Collectors.toList());
    }

    @Override
    public void save(Campaign campaign, SinglePlayerGameState gameState) throws IOException {
        this.internalSave(campaign, gameState, null);
    }

    @Override
    public void saveFileWithCampaign(Campaign campaign, Serializable saveMe, String fileName) throws IOException {
        File saveFile = new File(this.getSaveGamePath(campaign) + fileName);
        this.save(saveFile, saveMe);
    }

    @Override
    public void saveWithPostfix(Campaign campaign, SinglePlayerGameState gameState, String postfix) throws IOException {
        Objects.requireNonNull(postfix);
        this.internalSave(campaign, gameState, postfix);
    }

    public File getFileForGame(String fileName) throws IOException {
        this.createGameFolders();
        return new File(this.getGamePath() + fileName);
    }

    @Override
    public List<Campaign> getAllCampaigns() {
        this.createGameFolders();
        File[] files = new File(this.getGamePath()).listFiles();
        return Arrays.stream(files).filter(file -> file.isDirectory() && !file.isHidden()).sorted((f1, f2) -> -f1.getName().compareTo(f2.getName())).map(file -> new Campaign(LocalAppStoragePersistence.decodeString(file.getName()), file.getName())).collect(Collectors.toList());
    }

    public static String encodeString(String name) {
        return Text.encodeFileName(name);
    }

    public static String decodeString(String name) {
        return Text.decodeFileName(name);
    }

    @Override
    public Campaign createCampaign(String name) {
        if (name.length() > 30) {
            name = name.substring(0, 30);
        }
        Campaign campaign = new Campaign(name, LocalAppStoragePersistence.encodeString(name));
        this.createSaveGameFolders(campaign);
        return campaign;
    }

    @Override
    public PrintWriter getPersistentLog() {
        try {
            FileWriter fw = new FileWriter(this.getFileForGame(LOG_FILE_NAME), true);
            BufferedWriter bw = new BufferedWriter(fw);
            PrintWriter out = new PrintWriter(bw);
            return out;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private String getOsAppDataPath() {
        String path = "";
        String OS = System.getProperty("os.name").toUpperCase();
        path = OS.contains("WIN") ? System.getenv("APPDATA") : (OS.contains("MAC") ? System.getProperty("user.home") + "/Library/Application Support/" : (OS.contains("NUX") ? System.getProperty("user.home") : System.getProperty("user.dir")));
        if (path == "") {
            throw new IllegalStateException();
        }
        if (!File.separator.equals("" + path.charAt(path.length() - 1))) {
            path = path + File.separator;
        }
        return path;
    }

    private void internalSave(Campaign campaign, SinglePlayerGameState gameState, String filePostFix) throws IOException {
        SinglePlayerSimulation simulation = gameState.getSimulation();
        Frame frame = simulation.getCurrentFrame();
        RequestSaveGameState.instantlyDisableSaveRequest(frame);
        String _filePostFix = filePostFix == null ? "" : " " + filePostFix;
        this.createSaveGameFolders(campaign);
        long hour = TimeState.getHourOfDaySinceDay0(frame);
        long day = TimeState.getDaySinceDay0(frame) + 1;
        String gameDayHourString = "day " + day + " hour " + hour;
        String nowString = LocalAppStoragePersistence.getTimeString(ZonedDateTime.now());
        String fileName = LocalAppStoragePersistence.encodeString(nowString + "  " + gameDayHourString + _filePostFix) + SAVE_FILE_EXTENSION;
        this.saveFileWithCampaign(campaign, gameState, fileName);
    }

    private void save(File file, Serializable gameState) throws IOException {
        FileOutputStream fout = new FileOutputStream(file);
        ObjectOutputStream out = new ObjectOutputStream(fout);
        out.writeObject(gameState);
        out.flush();
    }

    private void createSaveGameFolders(Campaign campaign) {
        new File(this.getSaveGamePath(campaign)).mkdirs();
    }

    private void createGameFolders() {
        new File(this.getGamePath()).mkdirs();
    }

    private String getTextCraftPath() {
        return this.getOsAppDataPath() + "TextCraft" + File.separator;
    }

    private String getGamePath() {
        return this.getTextCraftPath() + LocalAppStoragePersistence.encodeString(this.versionedGameName) + File.separator;
    }

    private String getSaveGamePath(Campaign campaign) {
        return this.getGamePath() + this.getEncodedCampaignFolderName(campaign) + File.separator;
    }

    private String getEncodedCampaignFolderName(Campaign campaign) {
        String campaignName = campaign.campaignDisplayName;
        return LocalAppStoragePersistence.encodeString(campaignName);
    }

    private static String getTimeString(ZonedDateTime time) {
        DateTimeFormatter formatter = DateTimeFormatter.ofPattern("MM-dd-yy HH:mm:ss");
        return time.format(formatter);
    }
}

