/*
 * Decompiled with CFR 0.152.
 */
package com.fabriziopolo.textcraft.nlg;

import com.fabriziopolo.textcraft.nlg.IndependentClause;
import com.fabriziopolo.textcraft.nlg.NounPhrase;
import com.fabriziopolo.textcraft.nlg.Number;
import com.fabriziopolo.textcraft.nlg.Preposition;
import com.fabriziopolo.textcraft.nlg.Pronouns;
import com.fabriziopolo.textcraft.nlg.VerbPhrase;
import com.fabriziopolo.textcraft.nlg.Verbs;

public class ThereExistsClause
implements IndependentClause {
    private final NounPhrase thereWord = Pronouns.there;
    private final NounPhrase subject;
    private final Preposition preposition;
    private final NounPhrase objectOfPreposition;

    public ThereExistsClause(NounPhrase subject) {
        this.subject = subject;
        this.preposition = null;
        this.objectOfPreposition = null;
    }

    public ThereExistsClause(NounPhrase subject, Preposition preposition, NounPhrase objectOfPreposition) {
        this.subject = subject;
        this.preposition = preposition;
        this.objectOfPreposition = objectOfPreposition;
    }

    public String toString() {
        Number number = this.subject.getNumber();
        NounPhrase thereWordForm = this.thereWord.as(number);
        VerbPhrase toBeForm = Verbs.toBe.as(thereWordForm.getPerson(), number);
        String clause = thereWordForm + " " + toBeForm + " " + this.subject;
        if (this.preposition == null) {
            return clause;
        }
        String prepositionalPhrase = this.preposition + " " + this.objectOfPreposition;
        return clause + " " + prepositionalPhrase;
    }
}

