/*
 * Decompiled with CFR 0.152.
 */
package com.fabriziopolo.textcraft.events.sun;

import com.fabriziopolo.textcraft.events.position.PlayerExaminesSurroundingsEvent;
import com.fabriziopolo.textcraft.nlg.MultipleSentences;
import com.fabriziopolo.textcraft.nlg.Nlg;
import com.fabriziopolo.textcraft.nlg.Sentences;
import com.fabriziopolo.textcraft.simulation.Event;
import com.fabriziopolo.textcraft.simulation.Frame;
import com.fabriziopolo.textcraft.simulation.Simulation;
import com.fabriziopolo.textcraft.simulation.perception.Perceiver;
import com.fabriziopolo.textcraft.simulation.perception.PerceptionChannel;
import com.fabriziopolo.textcraft.states.sun.SunState;

public class SunStateChangedEvent
implements Event {
    private final long currHour;
    private final long prevHour;

    public SunStateChangedEvent(long currHour, long prevHour) {
        this.currHour = currHour;
        this.prevHour = prevHour;
    }

    @Override
    public Sentences asPerceivedBy(Perceiver perceiver, Frame frame, PerceptionChannel channel) {
        if (channel == PerceptionChannel.BLIND) {
            return null;
        }
        if (SunState.becamePitchBlack(this.currHour, this.prevHour)) {
            return this.perceptionOfVisibilityChange(perceiver, channel, frame, "It is now dark outside.");
        }
        if (SunState.becameNotPitchBlack(this.currHour, this.prevHour)) {
            return this.perceptionOfVisibilityChange(perceiver, channel, frame, "It is now light outside.");
        }
        Sentences changeDescription = SunState.getChangeDescription(this.currHour, this.prevHour);
        return changeDescription;
    }

    public Sentences perceptionOfVisibilityChange(Perceiver perceiver, PerceptionChannel channel, Frame frame, String changeMessage) {
        Sentences perceptionOfSurroundings = new PlayerExaminesSurroundingsEvent(perceiver, null).asPerceivedBy(perceiver, frame, channel);
        return MultipleSentences.builder().add(Nlg.literalSentences(changeMessage)).add(perceptionOfSurroundings).build();
    }

    public static void post(Simulation simulation, long currHour, long prevHour) {
        simulation.postEvent(new SunStateChangedEvent(currHour, prevHour));
    }
}

