/*
 * Decompiled with CFR 0.152.
 */
package com.fabriziopolo.textcraft.commands;

import com.fabriziopolo.textapp.TextAppController;
import com.fabriziopolo.textcraft.commands.AbstractCommand;
import com.fabriziopolo.textcraft.commands.ActionsAndHints;
import com.fabriziopolo.textcraft.commands.Command;
import com.fabriziopolo.textcraft.commands.LaunchWikiWebsiteAction;
import com.fabriziopolo.textcraft.commands.UserAction;
import com.fabriziopolo.textcraft.simulation.Frame;
import com.fabriziopolo.textcraft.simulation.Noun;
import com.fabriziopolo.textcraft.states.inventory.InventoryState;
import com.fabriziopolo.textcraft.states.position.PositionState;
import com.fabriziopolo.textcraft.text.TextMatcher;
import com.fabriziopolo.textcraft.wiki.WikiRenderer;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;

public class WikiCommand
extends AbstractCommand {
    public static final String WIKI_URL = "www.fabriziopolo.com/textcraft/wiki";
    public static final String HTTP_WIKI_URL = "http://www.fabriziopolo.com/textcraft/wiki";

    @Override
    public ActionsAndHints parse(String[] words, Command.Context context) {
        if (words.length == 0) {
            return null;
        }
        if (!words[0].toLowerCase().equals("wiki")) {
            return null;
        }
        if (words.length == 1) {
            return ActionsAndHints.action(new LaunchWikiWebsiteAction());
        }
        Frame frame = context.simulation.getCurrentFrame();
        PositionState positionState = PositionState.get(frame);
        Noun room = positionState.getContainingRoom(context.player);
        Set<Noun> accessibleNouns = positionState.getDesendentsOf(room);
        List<Noun> itemList = InventoryState.getItemList(context.player, frame);
        accessibleNouns.addAll(itemList);
        List<TextMatcher.ResultWithData<Noun>> resultWithData = WikiCommand.matchOne(words, 1, accessibleNouns, context.player, frame);
        List matchingActions = resultWithData.stream().filter(result -> result.isMatch()).map(result -> new PrintWikiAction((Noun)result.data)).collect(Collectors.toList());
        return new ActionsAndHints(matchingActions);
    }

    @Override
    public String getHelpString() {
        return "Type 'wiki' to open the Alpha Island wiki in your browser.";
    }

    @Override
    public String getNameString() {
        return "wiki";
    }

    @Override
    public String getPurposeString() {
        return "Launch the wiki in your browser.";
    }

    @Override
    public boolean isVisibleInHelp() {
        return true;
    }

    private static final class PrintWikiAction
    implements UserAction {
        private final Noun noun;

        private PrintWikiAction(Noun noun) {
            this.noun = noun;
        }

        @Override
        public String getDescription() {
            return "to print the wiki for " + this.noun.getContextFreeDescription();
        }

        @Override
        public void execute(TextAppController controller) {
            WikiRenderer wiki = new WikiRenderer(controller.getGameState().getSimulation().getCurrentFrame());
            controller.getTxt().println(wiki.getWikiDesciption(this.noun));
        }
    }
}

