/*
 * Decompiled with CFR 0.152.
 */
package com.fabriziopolo.textcraft.commands;

import com.fabriziopolo.textapp.TextAppController;
import com.fabriziopolo.textcraft.commands.ActionsAndHints;
import com.fabriziopolo.textcraft.commands.Command;
import com.fabriziopolo.textcraft.commands.UserAction;
import com.fabriziopolo.textcraft.events.status.PlayerExaminesStatusEvent;
import com.fabriziopolo.textcraft.simulation.Frame;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class StatusCommand
implements Command {
    private static final List<String> STATUS_SYNONYMS = Arrays.asList("status", "st");

    @Override
    public ActionsAndHints parse(String[] words, Command.Context context) {
        if (words.length != 1) {
            return null;
        }
        String word = words[0].toLowerCase();
        if (STATUS_SYNONYMS.contains(word)) {
            ArrayList<Result> results = new ArrayList<Result>();
            results.add(new Result(context));
            return new ActionsAndHints(results);
        }
        return null;
    }

    @Override
    public String getHelpString() {
        return "Type 'status' to see an overview of the state of your character.";
    }

    @Override
    public String getNameString() {
        return "status";
    }

    @Override
    public String getPurposeString() {
        return "Take stock of your health and other vital statistics. (st)";
    }

    @Override
    public boolean isVisibleInHelp() {
        return true;
    }

    public static final class Result
    implements UserAction {
        private final Command.Context context;

        private Result(Command.Context context) {
            this.context = context;
        }

        @Override
        public String getDescription() {
            return "to check your status";
        }

        @Override
        public void execute(TextAppController controller) {
            this.context.simulation.postEvent(new PlayerExaminesStatusEvent(this.context.player));
        }

        @Override
        public boolean isValid(Frame frame) {
            return true;
        }
    }
}

