/*
 * Decompiled with CFR 0.152.
 */
package com.fabriziopolo.textcraft.commands;

import com.fabriziopolo.textcraft.commands.AbstractCommand;
import com.fabriziopolo.textcraft.commands.ActionsAndHints;
import com.fabriziopolo.textcraft.commands.Command;
import com.fabriziopolo.textcraft.simulation.Frame;
import com.fabriziopolo.textcraft.simulation.Noun;
import com.fabriziopolo.textcraft.states.inventory.Inventory;
import com.fabriziopolo.textcraft.states.inventory.InventoryState;
import com.fabriziopolo.textcraft.text.Text;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;

public abstract class AbstractCommandWithTool
implements Command {
    private static final List<String> WITH_SYNONYMS = Arrays.asList("with", "using");

    abstract ActionsAndHints parseWithTool(String[] var1, Command.Context var2, Noun var3);

    @Override
    public ActionsAndHints parse(String[] words, Command.Context context) {
        Frame frame = context.simulation.getCurrentFrame();
        Integer withIdx = null;
        boolean foundWithWord = false;
        String withWord = null;
        for (int i = words.length - 1; i >= 0; --i) {
            withWord = words[i].toLowerCase();
            if (!WITH_SYNONYMS.contains(withWord)) continue;
            withIdx = i;
            foundWithWord = true;
            break;
        }
        if (foundWithWord) {
            ActionsAndHints resultsWithTool = this.getResultsWithTool(words, context, frame, withIdx);
            ActionsAndHints allResults = new ActionsAndHints().addAll(resultsWithTool);
            if (withWord.equals("with")) {
                allResults.addAll(this.parseWithTool(words, context, null));
            }
            return allResults;
        }
        Noun wieldedItem = InventoryState.get(frame).getWieldedItem(context.player);
        return this.parseWithTool(words, context, wieldedItem);
    }

    private ActionsAndHints getResultsWithTool(String[] words, Command.Context context, Frame frame, int withIdx) {
        Inventory inventory = InventoryState.get(context.simulation.getCurrentFrame()).get(context.player);
        if (inventory.getItems() != null) {
            List<Noun> matchingNouns = AbstractCommand.matchOne(words, withIdx + 1, inventory.getItems(), context.player, frame).stream().filter(result -> result.getStartIndex() + result.getNumWordsMatched() == words.length).map(result -> (Noun)result.data).collect(Collectors.toList());
            List<Noun> repTools = Text.chooseRepresentativesByDescription(matchingNouns, context.player, frame);
            if (repTools.isEmpty()) {
                return this.getHintsForBadTool();
            }
            return this.getResultsFromTools(words, context, withIdx, repTools);
        }
        return this.getHintForEmptyInventory();
    }

    private ActionsAndHints getResultsFromTools(String[] words, Command.Context context, Integer withIdx, List<Noun> repNouns) {
        ActionsAndHints resultsAndHints = new ActionsAndHints();
        int kWithIdx = withIdx;
        repNouns.forEach(noun -> resultsAndHints.addAll(this.parseWithTool(Arrays.copyOfRange(words, 0, kWithIdx), context, (Noun)repNouns.get(0))));
        return resultsAndHints;
    }

    private ActionsAndHints getHintsForBadTool() {
        return new ActionsAndHints().addHint("It sounds like you are trying to use an item to do something but I don't recognize the item.");
    }

    private ActionsAndHints getHintForEmptyInventory() {
        return new ActionsAndHints().addHint("It sounds like you are trying to use an item to do something but you have nothing in your inventory to use.");
    }
}

