/*
 * Decompiled with CFR 0.152.
 */
package com.fabriziopolo.textcraft.app.menu;

import com.fabriziopolo.textapp.TextAppController;
import com.fabriziopolo.textcraft.app.NumericTextMenu;
import com.fabriziopolo.textcraft.app.SinglePlayerGameState;
import com.fabriziopolo.textcraft.app.menu.NewCampaignMenuOptionAction;
import com.fabriziopolo.textcraft.app.menu.SwitchCampaignMenuOptionAction;
import com.fabriziopolo.textcraft.commands.UserAction;
import com.fabriziopolo.textcraft.peristence.Campaign;
import com.fabriziopolo.textcraft.simulation.Frame;
import java.util.List;
import java.util.function.Supplier;
import java.util.stream.Collectors;

public final class SwitchCampaignMenuMenuOptionAction
implements UserAction {
    private final String description;
    private final Supplier<SinglePlayerGameState> gameStateSupplier;

    public SwitchCampaignMenuMenuOptionAction(Supplier<SinglePlayerGameState> gameStateSupplier) {
        this(gameStateSupplier, "Switch Campaigns");
    }

    public SwitchCampaignMenuMenuOptionAction(Supplier<SinglePlayerGameState> gameStateSupplier, String description) {
        this.gameStateSupplier = gameStateSupplier;
        this.description = description;
    }

    @Override
    public String getDescription() {
        return this.description;
    }

    @Override
    public void execute(TextAppController controller) {
        List menuOptions = controller.getPersistence().getAllCampaigns().stream().map(campaign -> new SwitchCampaignMenuOptionAction((Campaign)campaign, this.gameStateSupplier)).collect(Collectors.toList());
        menuOptions.add(new NewCampaignMenuOptionAction(this.gameStateSupplier, "+ New Campaign"));
        controller.getParserExecutor().launchMenu(new NumericTextMenu("-- Choose a Campaign --", menuOptions, controller.getTxt(), true));
    }

    @Override
    public boolean isValid(Frame frame) {
        return true;
    }
}

