/*
 * Decompiled with CFR 0.152.
 */
package com.fabriziopolo.textcraft.app.menu;

import com.fabriziopolo.textapp.TextAppController;
import com.fabriziopolo.textcraft.app.NumericTextMenu;
import com.fabriziopolo.textcraft.app.SinglePlayerGameState;
import com.fabriziopolo.textcraft.app.menu.LoadGameMenuOptionAction;
import com.fabriziopolo.textcraft.app.menu.NewGameMenuOptionAction;
import com.fabriziopolo.textcraft.app.menu.SwitchCampaignMenuMenuOptionAction;
import com.fabriziopolo.textcraft.commands.UserAction;
import com.fabriziopolo.textcraft.peristence.Campaign;
import com.fabriziopolo.textcraft.simulation.Frame;
import java.io.File;
import java.util.List;
import java.util.function.Supplier;
import java.util.stream.Collectors;

public final class ShowLoadMenuMenuOptionAction
implements UserAction {
    private final Campaign campaignToSwitchTo;
    private final Supplier<SinglePlayerGameState> gameStateSupplier;

    public ShowLoadMenuMenuOptionAction(Campaign campaignToSwitchTo, Supplier<SinglePlayerGameState> gameStateSupplier) {
        this.campaignToSwitchTo = campaignToSwitchTo;
        this.gameStateSupplier = gameStateSupplier;
    }

    @Override
    public String getDescription() {
        return "Load a game";
    }

    @Override
    public void execute(TextAppController controller) {
        List menuOptions = controller.getPersistence().getSaveGameFilesForCampaign(this.campaignToSwitchTo).stream().map(file -> new LoadGameMenuOptionAction((File)file, this.campaignToSwitchTo)).collect(Collectors.toList());
        menuOptions.add(new NewGameMenuOptionAction("+ New Game", this.campaignToSwitchTo, this.gameStateSupplier));
        menuOptions.add(new SwitchCampaignMenuMenuOptionAction(this.gameStateSupplier, "+ Switch Campaigns"));
        controller.getParserExecutor().launchMenu(new NumericTextMenu("-- Load a Game for " + this.campaignToSwitchTo.campaignDisplayName + " --", menuOptions, controller.getTxt(), true));
    }

    @Override
    public boolean isValid(Frame frame) {
        return true;
    }
}

