/*
 * Decompiled with CFR 0.152.
 */
package com.fabriziopolo.textcraft.app.menu;

import com.fabriziopolo.textapp.TextAppController;
import com.fabriziopolo.textcraft.app.SinglePlayerGameState;
import com.fabriziopolo.textcraft.app.TextPrinter;
import com.fabriziopolo.textcraft.commands.UserAction;
import com.fabriziopolo.textcraft.events.position.PlayerExaminesSurroundingsEvent;
import com.fabriziopolo.textcraft.peristence.Campaign;
import com.fabriziopolo.textcraft.peristence.LocalAppStoragePersistence;
import com.fabriziopolo.textcraft.simulation.Frame;
import com.fabriziopolo.textcraft.simulation.Noun;
import java.io.File;

public final class LoadGameMenuOptionAction
implements UserAction {
    private final File fileToLoad;
    private final Campaign campaignToSwitchTo;

    public LoadGameMenuOptionAction(File fileToLoad, Campaign campaignToSwitchTo) {
        this.fileToLoad = fileToLoad;
        this.campaignToSwitchTo = campaignToSwitchTo;
    }

    @Override
    public String getDescription() {
        String name = this.fileToLoad.getName();
        if (name.endsWith(".sav")) {
            name = name.substring(0, name.length() - 4);
        }
        return LocalAppStoragePersistence.decodeString(name);
    }

    @Override
    public void execute(TextAppController controller) {
        controller.getTxt().println("Loading...");
        new Thread(() -> this.innerExecute(controller)).start();
    }

    private void innerExecute(TextAppController controller) {
        TextPrinter txt = controller.getTxt();
        try {
            SinglePlayerGameState gameState = controller.getPersistence().loadSinglePlayer(this.fileToLoad);
            txt.println("Loaded game.");
            txt.println();
            controller.setCampaign(this.campaignToSwitchTo);
            controller.setGameState(gameState);
            PlayerExaminesSurroundingsEvent.post((Noun)gameState.getPlayer(), gameState.getSimulation());
        }
        catch (Exception ex) {
            txt.println("Failed to load file.");
        }
    }

    @Override
    public boolean isValid(Frame frame) {
        return true;
    }
}

