/*
 * Decompiled with CFR 0.152.
 */
package com.fabriziopolo.textapp;

import com.fabriziopolo.textapp.InteractiveTextUi;
import com.fabriziopolo.textapp.TextListener;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.WindowEvent;
import java.io.InputStream;
import java.util.function.Consumer;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JScrollBar;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.text.DefaultCaret;

public class InteractiveTextUiSwingImpl
extends JPanel
implements ActionListener,
InteractiveTextUi,
FocusListener {
    public static final int TEXT_AREA_WIDTH = 84;
    public static final int TEXT_AREA_MARGIN = 2;
    public static final int TEXT_AREA_HEIGHT = 40;
    private static final int TEXT_AREA_LARGE_FONT_SIZE = 14;
    private static final int TEXT_AREA_SMALL_FONT_SIZE = 12;
    private static final int TEXT_AREA_VERY_SMALL_FONT_SIZE = 11;
    private static final int TEXT_AREA_TINY_FONT_SIZE = 10;
    private static final boolean antialiasText = false;
    protected JTextField textField;
    protected JTextArea textArea;
    protected JScrollPane scrollPane;
    private TextListener inputListener;
    private Consumer<InteractiveTextUi> onClose;
    private final JFrame externalJframe;
    private Consumer<String> oOnInput = null;
    boolean textFieldFocusGainedFirstTime = true;

    private InteractiveTextUiSwingImpl(JFrame frame) {
        super(new GridBagLayout());
        this.externalJframe = frame;
        this.externalJframe.addWindowListener(new WindowListener());
        double screenHeight = Toolkit.getDefaultToolkit().getScreenSize().getHeight();
        int fontSize = screenHeight < 720.0 ? 10 : (screenHeight == 720.0 ? 11 : (screenHeight < 900.0 ? 12 : 14));
        Font font = new Font("monospaced", 0, fontSize);
        if (font == null) {
            try {
                InputStream fontStream = this.getClass().getClassLoader().getResourceAsStream("Menlo-Regular.ttf");
                font = Font.createFont(0, fontStream).deriveFont((float)fontSize).deriveFont(0);
            }
            catch (Exception ex) {
                font = new Font("monospaced", 0, fontSize);
            }
        }
        Font finalFont = font;
        String OS = System.getProperty("os.name").toUpperCase();
        System.out.println("OS: " + OS + "  " + screenHeight + "p  Font: " + fontSize + "p");
        System.out.println("Font: " + font.getFontName());
        this.textField = new JTextField(84);
        this.textField.addActionListener(this);
        this.textField.addFocusListener(this);
        this.textField.setFont(font);
        this.textField.setText("enter text here");
        this.textArea = new AntialiasedJTextArea(40, 84);
        this.textArea.setEditable(false);
        this.textArea.setLineWrap(true);
        this.textArea.setWrapStyleWord(true);
        this.textArea.setFont(finalFont);
        this.textArea.setBackground(new Color(0, 0, 0));
        this.textArea.setForeground(new Color(200, 255, 200));
        DefaultCaret caret = (DefaultCaret)this.textArea.getCaret();
        caret.setUpdatePolicy(2);
        this.scrollPane = new JScrollPane(this.textArea);
        GridBagConstraints c = new GridBagConstraints();
        c.gridwidth = 0;
        c.fill = 1;
        c.weightx = 1.0;
        c.weighty = 1.0;
        this.add((Component)this.scrollPane, c);
        c.fill = 2;
        this.add((Component)this.textField, c);
        SwingUtilities.invokeLater(() -> InteractiveTextUiSwingImpl.centerWindow(frame));
    }

    @Override
    public void actionPerformed(ActionEvent evt) {
        String text = this.textField.getText();
        this.textField.selectAll();
        if (this.oOnInput != null) {
            this.oOnInput.accept(text);
            this.oOnInput = null;
            this.clearInput();
            return;
        }
        if (this.inputListener != null) {
            this.inputListener.onText(text);
        }
    }

    public static void centerWindow(Window frame) {
        Dimension dimension = Toolkit.getDefaultToolkit().getScreenSize();
        int x = (int)((dimension.getWidth() - (double)frame.getWidth()) / 2.0);
        int y = (int)((dimension.getHeight() - (double)frame.getHeight()) * 0.42857142857142855);
        frame.setLocation(x, y);
    }

    @Override
    public void onText(String text) {
        SwingUtilities.invokeLater(() -> {
            JScrollBar scrollBar = this.scrollPane.getVerticalScrollBar();
            boolean isAtBottom = scrollBar.getValue() == scrollBar.getMaximum() - scrollBar.getVisibleAmount();
            this.textArea.append(text);
            if (isAtBottom) {
                this.textArea.setCaretPosition(this.textArea.getDocument().getLength());
            }
        });
    }

    @Override
    public void setTitle(String title) {
        SwingUtilities.invokeLater(() -> this.externalJframe.setTitle(title));
    }

    @Override
    public void setInputListener(TextListener listener) {
        this.inputListener = listener;
    }

    @Override
    public void setClosingHandler(Consumer<InteractiveTextUi> onClose) {
        this.onClose = onClose;
    }

    @Override
    public void requireInput(Consumer<String> onInput) {
        this.oOnInput = onInput;
    }

    @Override
    public void clearInput() {
        SwingUtilities.invokeLater(() -> this.textField.setText(""));
    }

    @Override
    public void setForegroundColor(double red, double green, double blue) {
        SwingUtilities.invokeLater(() -> this.textArea.setForeground(new Color((int)red, (int)green, (int)blue)));
    }

    @Override
    public void setBackgroundColor(double red, double green, double blue) {
        SwingUtilities.invokeLater(() -> this.textArea.setBackground(new Color((int)red, (int)green, (int)blue)));
    }

    public static InteractiveTextUiSwingImpl createAndLaunch() {
        JFrame frame = new JFrame("TextCraft");
        frame.setDefaultCloseOperation(3);
        InteractiveTextUiSwingImpl ui = new InteractiveTextUiSwingImpl(frame);
        frame.add(ui);
        frame.pack();
        frame.setVisible(true);
        frame.setResizable(false);
        return ui;
    }

    @Override
    public void focusGained(FocusEvent e) {
        if (this.textFieldFocusGainedFirstTime) {
            this.textFieldFocusGainedFirstTime = false;
            SwingUtilities.invokeLater(() -> this.textField.setText(""));
        }
    }

    @Override
    public void focusLost(FocusEvent e) {
        this.textField.requestFocusInWindow();
    }

    private static void renderAntialiased(Graphics2D g2d) {
    }

    private class AntialiasedJTextArea
    extends JTextArea {
        AntialiasedJTextArea(int width, int height) {
            super(width, height);
        }

        @Override
        protected void paintComponent(Graphics g) {
            InteractiveTextUiSwingImpl.renderAntialiased((Graphics2D)g);
            super.paintComponent(g);
        }
    }

    private class WindowListener
    implements java.awt.event.WindowListener {
        private WindowListener() {
        }

        @Override
        public void windowOpened(WindowEvent e) {
        }

        @Override
        public void windowClosing(WindowEvent e) {
            if (InteractiveTextUiSwingImpl.this.onClose != null) {
                InteractiveTextUiSwingImpl.this.onClose.accept(InteractiveTextUiSwingImpl.this);
            }
        }

        @Override
        public void windowClosed(WindowEvent e) {
        }

        @Override
        public void windowIconified(WindowEvent e) {
        }

        @Override
        public void windowDeiconified(WindowEvent e) {
        }

        @Override
        public void windowActivated(WindowEvent e) {
        }

        @Override
        public void windowDeactivated(WindowEvent e) {
        }
    }
}

