module AR
  module Game

    class Cave04HiddenPassageEast < PhysicalObject 
      def initialize id=nil
        super 
        self.noun = "hidden passage east"
        self.discovery_threshold = 8
        add_behavior Gateway
        add_story_implement StoryImplement.new
        #add_behavior AR::Game::SomeBehavior
      end


      #sort of just a way to 'include' these classes, so you don't
      #need to fully qualify them.  There must be a better way...

      class Story < AR::Game::StoryBehavior::Story
      end

      class StoryImplement < AR::Game::StoryBehavior::StoryImplement

        def initialize stories=[]
          super

          story =  Story.new when: AR::Events::DiscoveryMadeEvent, as: "discovered" do |e|
            if e.perceiver == e.engine.world.player
              ret = "You notice behind a wall of cacooned corpses on the east side of the chamber, there is a narrow tunnel leading east."
            else 
              ret = ""
            end
            ret 
          end
          add_story story


          story =  Story.new when: AR::Events::DiscoverableInspectedEvent, as: "discoverable" do |e|
            if e.inspector == e.engine.world.player
              ret = "The hidden passage east is thoroughly obscured by a pile of cacooned corpses. Luckily you are very perceptive."
            else 
              ret = ""
            end
            ret 
          end
          add_story story

          story =  Story.new when: AR::Events::ARObjectTravelledEvent, as: "gateway" do |e|
            if e.traveller == e.engine.world.player
              ret = "You wade through the cacooned corpses and webs and make your way to another cavern chamber."
            else 
              ret = ""
            end
            ret 
          end
          add_story story
        end#initialize

      end#StoryImplement



    end#Gateway class



  end#Game
end#AR
