module AR
  module Game

    class Cave03PassageEast < PhysicalObject 
      def initialize id=nil
        super 
        self.noun = "passage east (deeper into the cave)"
        add_behavior Gateway
        add_story_implement StoryImplement.new
        #add_behavior AR::Game::SomeBehavior
      end


      #sort of just a way to 'include' these classes, so you don't
      #need to fully qualify them.  There must be a better way...

      class Story < AR::Game::StoryBehavior::Story
      end

      class StoryImplement < AR::Game::StoryBehavior::StoryImplement

        def initialize stories=[]
          super

          story =  Story.new when: AR::Events::DiscoverableInspectedEvent, as: "discoverable" do |e|
            if e.inspector == e.engine.world.player
              ret = "The wall of web covering the way east is littered with cacoons of miscellaneous body parts.  You feel very reluctant to make your way through it."
            else 
              ret = ""
            end
            ret 
          end
          add_story story


          story =  Story.new when: AR::Events::DiscoveryMadeEvent, as: "discovered" do |e|
            if e.perceiver == e.engine.world.player
              ret = "On the eastern side of the chamber, there is a wall of web, behind which you can see passage, thanks to your torch."
            else 
              ret = ""
            end
            ret 
          end
          add_story story

          story =  Story.new when: AR::Events::ARObjectTravelledEvent, as: "gateway" do |e|
            if e.traveller == e.engine.world.player
              ret = "You press through the wall of web, as disgusting as it is."
            else 
              ret = ""
            end
            ret 
          end
          add_story story
        end#initialize

      end#StoryImplement



    end#Gateway class



  end#Game
end#AR
