module AR::Game::Equippable 
  
  #add attr_accessor properties here... 
  #if you don't need them serialized on save
  #
  attr_accessor :slot
  attr_accessor :on_equipped
  attr_accessor :on_unequipped

  def self.slots
    {
      body: :body,
      main_hand: :main_hand,
      off_hand: :off_hand 
    }
  end

  #...initialize them here
  def self.init ar_object 
    #add attr_serializeable properties here... 
    #if you do need them serialized on save
    #ar_object.attr_serializeable :prop1, :prop2, &block
    ar_object.slot = :main_hand 
    ar_object.on_equipped = Proc.new do end
    ar_object.on_unequipped = Proc.new do end
  end

  def self.extended ar_object
    self.init ar_object
    
    ar_object.resolutions.push call_on_equipped_on_event
    ar_object.resolutions.push call_on_unequipped_on_event
  end 

  def self.call_on_equipped_on_event
    AR::Events::Resolution.new event_class: AR::Events::ItemEquipped, as: "item" do |e|
      item = e.item
      eq = e.equipper
      item.on_equipped.call(eq)
    end
  end

  def self.call_on_unequipped_on_event
    AR::Events::Resolution.new event_class: AR::Events::ItemUnequipped, as: "item" do |e|
      item = e.item
      eq = e.equipper
      item.on_unequipped.call(eq)
    end
  end




end
