module AR::Game::LootableContainer 

  
  

  #...initialize them here
  def self.init ar_object 
    ar_object.add_behavior AR::Game::InventoryBehavior
  end

  def self.extended ar_object
    init ar_object

    ar_object.resolutions << xfer_items_on_looted
  end 

  def self.xfer_items_on_looted
    AR::Events::Resolution.new event_class: AR::Events::Loot, as: "container" do |e|
      c = e.container
      l = e.looter
      results = []
      c.inventory_items.each do |item|
        results.push AR::Events::ItemRemovedFromInventory.new item: item, inventory_owner: c
        results.push AR::Events::ItemAddedToInventory.new item: item, inventory_owner: l 
      end
      results
    end
  end


  #add more methods here

end
