module AR
  module Game

    class Cave03 < Scene
      def initialize id=nil
        super 

        self.noun = "cave"

        spawner = AR::Events::Resolution.new event_class: AR::Events::ARObjectEnteredInhabitableEvent, as: "inhabitable" do |e| 
          g = e.gateway 
          unless g.nil?
            if g.class.to_s.include? "Cave02" 
              m = CaveSpider.new "#{self.id}_spider_#{AR::Game::ARObject.gen_id}"
              m.subscribe!
              init_gs = AR::Events::GaugesInitialized.new gauge_manager: m 
              init_gs.resolve!
              e.engine.after_step AR::Events::ARObjectEnteredInhabitableEvent.new enterer: m, inhabitable: e.inhabitable, dont_narrate: true
              e.engine.after_step AR::Events::NarrationEvent.new narration: "All of a sudden you torch reveals something terrifying.  From the eastern part of the chamber, a very large cave spider is crawling as quietly as possible toward you.  It begins chitter-chattering as though hungry." 
              nil
            end
          end
        end
        self.resolutions.push(spawner)


        add_story_implement StoryImplement.new
      end


      class Story < AR::Game::StoryBehavior::Story
      end

      class StoryImplement < AR::Game::StoryBehavior::StoryImplement
        def initialize stories=[]
          super

          story =  Story.new when: AR::Events::ARObjectEnteredInhabitableEvent, as: "inhabitable" do |e|
            if e.enterer == e.engine.world.player
              ret = "Entering the chamber, your feet stick to the ground every few steps, as there are patches of spider web decorating the area.  It seems to be a spider's nest."
            else 
              ret = ""
            end
            ret 
          end
          add_story story

          story =  Story.new when: AR::Events::DiscoverableInspectedEvent, as: "discoverable" do |e|
            if e.inspector == e.engine.world.player
              ret = "Waving your torch around, you notice groups of cacoons scattered throughout the chamber.  Ambiguous, lifeless limbs press out from the inside of them, as though trying to escape."
            else 
              ret = ""
            end
            ret 
          end
          add_story story
        end
      end
    end




  end
end
