class AR::Events::DamageReceived < AR::Events::Event

  attr_participant :damaged, :damager
  attr_accessor :damage_amount

  def initialize params
    super params
    #any props that aren't participants need to be set here
    #otherwise they are set by superclass through meta routines
    self.damage_amount = params[:damage_amount]
  end 

  def default_story
    "#{damaged.name.capitalize} receives #{damage_amount} damage from #{damager.name}."
  end

end
