require "./lib/apocrodentia"
require "test/unit"
require_relative "../classes.rb"

class TestActorBehavior < BaseBehaviorTestCase 

  def setup
    super
    @subject = Traveller.new
    puts "subj: #{@subject.class}"
    test_init_gauges
  end

  def test_action_points_decreased_on_action_performed 
    action = AR::Game::InspectAction.new @subject
    e = AR::Events::ActionPerformedEvent.new performer: @subject, action: action
    results = e.resolve!
    result = results.select{|ev| ev.class == AR::Events::GaugeChanged}.last

    assert_equal @subject.gauge("action_points"), result.gauge
    assert_equal "current", result.which 
    assert_equal -action.ap_cost, result.amount
  end


end

