module AR
  module Game

    class Cave02 < Scene
      def initialize id=nil
        super 

        self.noun = "cave"


        add_story_implement StoryImplement.new
      end


      class Story < AR::Game::StoryBehavior::Story
      end

      class StoryImplement < AR::Game::StoryBehavior::StoryImplement
        def initialize stories=[]
          super

          story =  Story.new when: AR::Events::ARObjectEnteredInhabitableEvent, as: "inhabitable" do |e|
            if e.enterer == e.engine.world.player
              ret = "You enter a large, cool chamber of the cave.  The darkness of the cavern seems to swallow the light of your torch, leaving a 15 foot field of vision.  An occasional dripping noise echos from some unkown origin every few seconds."
            else 
              ret = ""
            end
            ret 
          end
          add_story story

          story =  Story.new when: AR::Events::DiscoverableInspectedEvent, as: "discoverable" do |e|
            if e.inspector == e.engine.world.player
              ret = "You find the edge of the chamber and make your way around it, searching for a passage deeper."
            else 
              ret = ""
            end
            ret 
          end
          add_story story
        end
      end
    end




  end
end
