module AR::Game::InventoryBehavior 
  #add attr_accessor properties here... 
  
  #...initialize them here
  def self.init ar_object 
    ar_object.class.attr_serializeable :inventory_item_ids
    ar_object.inventory_item_ids = []
  end

  def self.extended ar_object
    self.init ar_object
    ar_object.resolutions << item_added_to_inventory_on_event
    ar_object.resolutions << item_removed_from_inventory_on_event
    ar_object.resolutions << release_item_removed_from_inventory_on_given_event
    ar_object.resolutions << release_item_added_to_inventory_on_received_event

  end 

  def self.item_added_to_inventory_on_event
    AR::Events::Resolution.new event_class: AR::Events::ItemAddedToInventory, as: "inventory_owner" do |e|
      owner = e.inventory_owner
      item = e.item
      owner.add_inventory_item item
      item.owner = owner
      nil
    end
  end

  def self.item_removed_from_inventory_on_event
    AR::Events::Resolution.new event_class: AR::Events::ItemRemovedFromInventory, as: "inventory_owner" do |e|
      owner = e.inventory_owner
      item = e.item
      owner.rem_inventory_item item
      item.owner = nil
      nil
    end
  end

  def self.release_item_removed_from_inventory_on_given_event
    AR::Events::Resolution.new event_class: AR::Events::ItemGivenEvent, as: "giver" do |e|
      owner = e.giver
      item = e.item
      owner.create AR::Events::ItemRemovedFromInventory, inventory_owner: owner, item: item
    end
  end

  def self.release_item_added_to_inventory_on_received_event
    AR::Events::Resolution.new event_class: AR::Events::ItemGivenEvent, as: "receiver" do |e|
      owner = e.receiver
      item = e.item
      owner.create AR::Events::ItemAddedToInventory, inventory_owner: owner, item: item
    end
  end




  
  def inventory_items
    inventory_item_ids.map{|id| world.find id }.compact
  end

  def add_inventory_item item
    inventory_item_ids.push item.id
  end
  
  def remove_inventory_item item
    inventory_item_ids.delete item.id
  end


  def rem_inventory_item item
    inventory_item_ids.delete item.id
  end

end
