#this is only used for the new game began event
#it initializes gauges, since this only should happen for a new game
module AR::Game::GaugeManagement 
  
  #add attr_accessor properties here... 
  #if you don't need them serialized on save
  attr_accessor :gauge_info_to_initialize
  attr_accessor :after_init_gauge_routines
   

  #...initialize them here
  def self.init ar_object 
    ar_object.class.attr_serializeable :gauge_ids

    ar_object.gauge_info_to_initialize = []
    ar_object.after_init_gauge_routines = []
    ar_object.gauge_ids = []
  end

  def self.extended ar_object
    self.init ar_object
    
    ar_object.resolutions.push initialize_gauges_on_gauges_initialized
    ar_object.resolutions.push remove_gauges_from_game_on_removed 
  end 

  def self.remove_gauges_from_game_on_removed 
    AR::Events::Resolution.new event_class: AR::Events::ObjectRemovedFromGame, as: "ar_object" do |e|
      results = []
      obj  = e.ar_object
      obj.gauges.each{|g|
        results.push(AR::Events::ObjectRemovedFromGame.new ar_object: g)
      }
      results
    end
  end



  def self.initialize_gauges_on_gauges_initialized
    AR::Events::Resolution.new when: AR::Events::GaugesInitialized, as: "gauge_manager" do |e|

      gm = e.gauge_manager
      gm.gauge_info_to_initialize.map do |gi|
        g = AR::Game::Gauge.new(gi[:id])
        g.name = gi[:name]
      end

      gm.after_init_gauge_routines.map{|gr| gr.call gm }
      nil
    end
  end


  def gauge_id_from_name n
    "#{self.id}_#{n}"
  end

  def gauge name
    self.world.find gauge_id_from_name(name)
  end

  def register_gauge name
    gauge_info_to_initialize.push name: name, id: gauge_id_from_name(name)
    @all_gauges_cached = nil
    gauge_ids.push gauge_id_from_name(name)
  end 

  def after_gauges_init &routine
    after_init_gauge_routines.push routine
  end

  def gauges
    @all_gauges_cached ||= gauge_ids.map{|gid| world.find gid }
  end


  #add more methods here

end
