module AR
  module Game

    class Cave01 < Scene
      def initialize id=nil
        super 

        self.noun = "cave"

        self.resolutions << (AR::Events::Resolution.new event_class: AR::Events::ARObjectEnteredInhabitableEvent, as: "inhabitable" do |e|
          inh = e.enterer
          inv_items = inh.inventory_item_ids


          unless inv_items.include? "torch"
            e.dont_narrate = true
            [
              AR::Events::NarrationEvent.new(narration: "In the darkness you can hear a horrid chittering sound.  It becomes quite louder, and you hear a leap.  Something grabs you and pulls you into the darkness.  Unable to see anything, you are completely helpless."),
              AR::Events::ARObjectDied.new(ar_object: inh)
            ]
          end
        end)
        

        add_story_implement StoryImplement.new
      end


      class Story < AR::Game::StoryBehavior::Story
      end

      class StoryImplement < AR::Game::StoryBehavior::StoryImplement
        def initialize stories=[]
          super

          story =  Story.new when: AR::Events::ARObjectEnteredInhabitableEvent, as: "inhabitable" do |e|
            ret = ""
            if e.enterer == e.engine.world.player
              ret = "Your flickering torch illuminates the cavern as you enter."
            else 
              ret = ""
            end
            ret 
          end
          add_story story

          story =  Story.new when: AR::Events::DiscoverableInspectedEvent, as: "discoverable" do |e|
            if e.inspector == e.engine.world.player
              ret = "The cavern is dusty, and you can feel a warm breath whisper from deeper within as if the mountain has a pulse."
            else 
              ret = ""
            end
            ret 
          end
          add_story story
        end
      end
    end




  end
end
