module AR
  module Game

    class GuardPike < PhysicalObject
      def initialize id=nil
        super 
        add_behavior AR::Game::GatewayBlocker

        self.article = self.definite_article = "the guard's"
        self.noun = "pike"
        add_story_implement BlockerStory.new 
#        self.blocked_entry_story = "The guard shoves his spear out in front of the door.  Obviously he has no intent on letting you pass"
      end

      class BSI < AR::Game::StoryBehavior::StoryImplement
      end
      class Story < AR::Game::StoryBehavior::Story
      end

     class BlockerStory < BSI
        def initialize stories=[]
          super
          s = Story.new when: AR::Events::DiscoverableInspectedEvent, as: "discoverable" do |e|
            player = e.engine.world.player
            ret = ""
            if e.inspector == e.engine.world.player
              ret = "The guard's spear is about 6 feet tall, and is being held accross the door."
            end
          end
          add_story s

          s = Story.new when: AR::Events::DiscoveryMadeEvent, as: "discovered" do |e|
            player = e.engine.world.player
            ret = ""
            if e.perceiver == e.engine.world.player
              ret = "The stout spear of the guard is blocking the way into the inn."
            end
          end
          add_story s
        end
      end
    end

  end
end
