module AR
  @@world_class = nil
  def self.world_class=w
    @@world_class  = w 
  end

  def self.world_class
    @@world_class
  end


  def self.recursive_symbolize(value)
    if value.is_a?(Array)
      array = value.map{|x| x.is_a?(Hash) || x.is_a?(Array) ? recursive_symbolize(x) : x}
      return array
    end
    if value.is_a?(Hash)
      hash = value.inject({}){|memo,(k,v)| memo[k.to_sym] = recursive_symbolize(v); memo}
      return hash
    end
    return value
  end
  def self.log s, tag="game"
    log_dir = "./log_ar"
    fname = "#{tag}.log"
    Dir.mkdir(log_dir) unless Dir.exists? "./log_ar"
    fpath = "#{log_dir}/#{fname}" 
    t = Time.now
    stamp = t.strftime "%D @%T"
    File.open fpath, "a" do |file|
      file.puts "[#{stamp}] #{s}"
    end 
    
  end
  module Input


    def self.take_key
      k = nil

      while (k = KeySensor.get_key).nil?
      end

      k
    end

    def self.clear_buffer
      if !KeySensor.get_key.nil?
        @buffer = []
        until (k=KeySensor.get_key).nil?
          @buffer << k 
        end
        sleep(0.2)
        return @buffer
        
      end
    end

    class Prompt
      attr_accessor :on_response
      attr_accessor :prompt_msg
      attr_accessor :prompt_tick
      def initialize prompt_msg, on_response, prompt_tick=nil
        @prompt_msg = prompt_msg
        @on_response = on_response
        @prompt_tick = prompt_tick || ">>> "
      end

      def listen
        Input.clear_buffer
        AR.put_s prompt_msg unless prompt_msg.empty?
        AR.print_s prompt_tick 
      end
    end

    class CommandPrompt < Prompt
      def initialize prompt_msg, on_response,prompt_tick=nil
        super prompt_msg, on_response, prompt_tick
      end

      def listen 
        super
        command = gets.chomp
        on_response.call command
      end
    end

    class KeyPushPrompt < Prompt

      def initialize prompt_msg, on_response, prompt_tick=nil
        super prompt_msg, on_response, prompt_tick
      end

      def listen
        super
        k = Input.take_key
        on_response.call k
      end
    end

  end#Input
end#AR 
require "apocrodentia/events"
require "apocrodentia/game"
require "apocrodentia/narrator"
require "apocrodentia/generate"
require "apocrodentia/gauge"

module AR
  @@printer = AR::Game::Printer.new
  @@printer.console_width = nil
  def self.printer
    @@printer
  end

  def self.print_s str
    printer.print_s str 
  end

  def self.put_s str
    printer.put_s str
  end
end

