package mechanique;

 

/*    
    
    MechaniQue, the programming language for Interactive Fiction
    Copyright (C) 2007  G.J.G.T. (Gabor) de Mooij

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation (highest version applies !!).

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License along
    with this program; if not, write to the Free Software Foundation, Inc.,
    51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA.
    ---MECHANIQUESOFT/GABOR DE MOOIJ

*/

 
import java.io.*;
import java.util.*;
import java.util.regex.*;
import java.applet.*;
import java.io.Serializable;
import java.lang.Math;
;

public class Terminal implements Printable, Commandline, Serializable
{
    private StoryController controller;
    private String buff = "";
    private Runtime rt;

    public void setStory(StoryController s)
    {
        controller = s;
    }
    
    public void print(String t)
    {
        if (t.endsWith("-")){
            this.buff+=t.replaceAll("-$","");        
        } else {
            toolbox.say(this.buff+t);
            this.buff="";
        }
    }
    
    public void input(Receiver r)
    {
        String a = toolbox.ask();
        
        if (a.equals("#exit"))
        {
            this.controller.stopStory();
        }
        
         
        if (a.equals("#mem")){
           Runtime rt = Runtime.getRuntime();
           toolbox.say(""+rt.freeMemory()+" FREE / "+rt.totalMemory());
        }
        
         r.setWait(true);
         r.receive(a,false);
         
    }
}
