package mechanique;

 

/*    
    
    MechaniQue, the programming language for Interactive Fiction
    Copyright (C) 2007  G.J.G.T. (Gabor) de Mooij

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation (highest version applies !!).

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License along
    with this program; if not, write to the Free Software Foundation, Inc.,
    51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA.
    ---MECHANIQUESOFT/GABOR DE MOOIJ

*/

 
import java.io.*;
import java.util.*;
import java.util.regex.*;
import java.applet.*;
import java.io.Serializable;
import java.lang.Math;
;

public class StoryLine implements StoryLineInterface, Serializable
{

    private List<Executable> ActionCollection = new ArrayList<Executable>();
    private List<Unlockable> LockCollection = new ArrayList<Unlockable>();
    private Printable GUI;
    private Story theStory;
    private boolean unlocked;
    private List<String> usedKeys = new ArrayList<String>();
    
    public void StoryLine()
    {
        
        
    }
    
    public void run()
    {
    	   	
        this.open();
        if (this.unlocked){
            this.doActions();
        } 
        
    }
    
    public void changeState(ORLock o, boolean s)
    {
        this.unlocked = s;
    }

    public boolean getState()
    {
        return this.unlocked;
    }
    
    public Story getStory()
    {
        return this.theStory;
    }
    
        
    private void open()
    {
        this.usedKeys.clear();
        this.unlocked = true;
        this.getStory().getWallet().dropAll("or");
        
        for (int j=0; j < this.LockCollection.size(); j++)
        {
            if (!this.LockCollection.get(j).unlock(this.theStory.getWallet()))
            {
            		
		 this.unlocked = false;
            
            } else if (!(this.LockCollection.get(j) instanceof ORLock)) {
            
                this.getStory().getWallet().add("or");
                
            }
        }
        
        
    }
    
    private void doActions()
    {
        this.dropUsedKeysForSlots();
        for (int j=0; j<this.ActionCollection.size(); j++)
        {
            this.ActionCollection.get(j).execute();
        }
    }
    
    private void dropUsedKeysForSlots()
    {
        for (int j=0; j < this.usedKeys.size(); j++)
        {
            this.theStory.getWallet().drop(this.usedKeys.get(j));
        }
    }
    
    
    public void addAction(Executable a)
    {
        a.setStoryLine(this);
        ActionCollection.add(a);
    }
    
    public void addLock(Unlockable l)
    {
        l.setStoryLine(this);
        LockCollection.add(l);
    }
    
    public void dropList(String key)
    {
        this.usedKeys.add(key);
    }
    
    public void setStory(Story s)
    {
        this.theStory = s;
        this.GUI = s.getDisplayUnit();
    }
    

}
