##########################################################################
#
#
# Little girl in the big world. An Interactive Fiction story file.
# Designed to be compiled and run with StoryFactory.
#
# Written and declared public domain by Peter Wendrich 2003.
#
#
##########################################################################
#
# Doors connecting all the rooms
#
##########################################################################

#
# Open / close state of all doors
#
vars {
#
# ground floor
  $frontDoorOpen

#
# first floor
  $doorAliceBedroomOpen
  $doorMasterBedroomOpen

  $windowAliceBedroomOpen

#
# second floor
  $hatchAtticOpen
}

#
#
# inputs
#   new room
# outputs
#   --
#
sub _follow {
# !!! check alice is in same room as you are
  isActorAlice /if
    &objectPlayer [+1] /store
    ^ you follow Alice .
  /else
    &objectAlice [+1] /store
    ^ Alice follows you .
    &ALICE_standingInRoom /to $aliceMode
  /then
}

#
# enter new room
#
# inputs
#   new room
# outputs
#   --
#
sub enterRoom {
# leave oldroom
#  /get $actor _findRoom
  &ALICE_standingByDoor changeMode
  /dup _follow
  /get $actor [+1] /store
}

sub closedThing {
  isActorAlice /if her /else your /then path is blocked by a closed
}

sub closedDoor {
  closedThing door .
}

sub closedWindow {
  closedThing window .
}

object doorGndToOutside {
  name: n north front door exit
  location: objectHallGroundFloor

  run {
    /dup &close /eqif
      isActorAlice /if
        /get $frontDoorOpen /nif
          it is not open .
        /then
        /0 /to $frontDoorOpen
        done .
        /drop /tret
      /then
    /then
    /dup &enter /eq /over &n /eq /or /if
      /get $frontDoorOpen /nif closedDoor /drop /tret /then
      &objectVoid &objectAlice [+1] /store
      &objectVoid &objectPlayer [+1] /store
      Alice hugs you before she leaves for school . `` bye '', says Alice .
      she closes the door and you run off to a quiet corner of the house . ^ ^
      for a moment you wonder if you really exist , or that everything is just
      another fantasy of a seven year old girl . you fall a sleep and dream
      about Alice and her dollhouse . ^ ^
      printScores ^ ^
      thank you for playing , ^
      type ` quit ' to leave the game . ^
      /drop /tret
    /then
    /dup &open /eqif 
      isActorAlice /if
        /get $frontDoorOpen /if
          `` it is already open . '', says Alice .
          /drop /tret
        /then
        &objectAlice wearingObject /nif
          `` I can't go outside , I'm naked ! '', says Alice .
          /drop /tret
        /then
        &objectAlice wearingObject &objectPajama /eqif
          `` I can't go outside in my pajama . '', says Alice .
          /drop /tret
        /then
        &objectAlice wearingObject &objectUnderwear /eqif
          `` I can't go outside in only my underwear . '', says Alice .
          /drop /tret
        /then
        /1 /to $frontDoorOpen
        done .
        /drop /tret
      /then
    /then
    /dup &look /eqif _exits the front door to the north . /drop /tret /then
    /drop /fret
  }
}

#object doorGndToLivingRoom {
#  name: w west door exit leading west
#  location: objectHallGroundFloor
#
#  run {
#    /dup &enter /eq /over &w /eq /or /if
#      &objectLivingRoom enterRoom /drop /tret
#    /then
#    /dup &look /eqif _exits a door to the west leading to the living room . /drop /tret /then
#    /drop /fret
#  }
#}

#object doorGndToKitchen {
#  name: s south door exit leading south
#  location: objectHallGroundFloor
#
#  run {
#    /dup &enter /eq /over &s /eq /or /if
#      &objectKitchen enterRoom /drop /tret
#    /then
#    /dup &look /eqif _exits a door to the south leading to the kitchen . /drop /tret /then
#    /drop /fret
#  }
#}

object stairsGndToHall {
  name: u up stairs exit
  location: objectHallGroundFloor

  run {
    /dup &enter /eq /over &u /eq /or /if
      &objectHallFirstFloor enterRoom /drop /tret
    /then
    /dup &look /eqif _exits stairs leading up . /drop /tret /then
    /drop /fret
  }
}

object stairsHallToGnd {
  name: d down stairs exit
  location: objectHallFirstFloor

  run {
    /dup &enter /eq /over &d /eq /or /if
      &objectHallGroundFloor enterRoom /drop /tret
    /then
    /dup &look /eqif _exits stairs leading down . /drop /tret /then
    /drop /fret
  }
}

object doorHallToMasterBedroom {
  name: w west door exit leading west master bedroom 
  location: objectHallFirstFloor

  run {
    /dup &enter /eq /over &w /eq /or /if
      /get $doorMasterBedroomOpen /nif closedDoor /drop /tret /then
      &objectMasterBedroom enterRoom /drop /tret
    /then
    /dup &look  /eqif
      _exits /get $doorMasterBedroomOpen /if an open /else a closed /then door leading west . /drop /tret
    /then
    /dup &open  /eqif
      /get $doorMasterBedroomOpen /if the door is already open . /drop /tret /then
      isActorPlayer /if _tooHeavy /drop /tret /then
      /1 /to $doorMasterBedroomOpen done . /drop /tret
    /then
    /dup &close /eqif
      /get $doorMasterBedroomOpen /nif the door is already closed . /drop /tret /then
      isActorPlayer /if _tooHeavy /drop /tret /then
      /0 /to $doorMasterBedroomOpen done . /drop /tret
    /then
    /drop /fret
  }
}

object doorHallToAliceBedroom {
  name: s south door exit leading south Alice's bedroom 
  location: objectHallFirstFloor

  run {
    /dup &close /eqif
      /get $doorAliceBedroomOpen /nif the door is already closed . /drop /tret /then
      isActorPlayer /if _tooHeavy /drop /tret /then
      &ALICE_standingByDoor changeMode
      /0 /to $doorAliceBedroomOpen done . /drop /tret
    /then
    /dup &enter /eq /over &s /eq /or /if
      /get $doorAliceBedroomOpen /nif closedDoor /drop /tret /then
      &objectAliceBedroom enterRoom /drop /tret
    /then
    /dup &look /eqif _exits /get $doorAliceBedroomOpen /if an open /else a closed /then door leading south . /drop /tret /then
    /dup &open /eqif
      /get $doorAliceBedroomOpen /if the door is already open . /drop /tret /then
      isActorPlayer /if _tooHeavy /drop /tret /then
      &ALICE_standingByDoor changeMode
      /1 /to $doorAliceBedroomOpen done . /drop /tret
    /then
    /drop /fret
  }
}

object hatchAtticToHall {
  name: d down hatch exit
  location: objectAttic
  run {
    /dup &enter /eq /over &d /eq /or /if
      /get $hatchAtticOpen /if 
        &objectHallFirstFloor enterRoom /drop /tret
      /then
    /then
    /dup &look /eqif _exits hatch in the floor leading down . /drop /tret /then
    /dup &name /eqif the hatch /drop /tret /then
    /drop /fret
  }
}

object hatchHallToAttic {
  name: u up hatch exit
  location: objectHallFirstFloor
  run {
    /dup &enter /eq /over &u /eq /or /if
      /get $hatchAtticOpen /if 
        &objectAttic enterRoom /drop /tret
      /then
    /then
    /dup &look /eqif _exits /get $hatchAtticOpen /if an open /else a closed /then hatch in the ceiling . /drop /tret /then
    /dup &tell /eqif isActorAlice /if `` the hatch leads to the attic . '', says Alice . /drop /tret /then /then
    /dup &name /eqif the hatch /drop /tret /then
    /dup &open /eqif
      isActorAlice /if
        /get $hatchAtticOpen /if
          it is already open .
          /drop /tret
        /else
          /get $aliceMode &ALICE_standingOnCage /eqif
            /1 /to $hatchAtticOpen
            the hatch opens and a ladder rolls down from the attic .
            /drop /tret
          /then
          /get $aliceMode &ALICE_standingOnGreenBox /eqif
            `` I can almost reach it , but it's still too high . '', says Alice . ^
            sure , next year she will be tall enough .
            /drop /tret
          /then
          `` it's too high . '', says Alice .
          /drop /tret
        /then
      /then
    /then
    /drop /fret
  }
}

object doorMasterBedroomToHall {
  name: e east door exit
  location: objectMasterBedroom

  run {
    /dup &enter /eq /over &e /eq /or /if
      /get $doorMasterBedroomOpen /nif closedDoor /drop /tret /then
      &objectHallFirstFloor enterRoom /drop /tret
    /then
    /dup &look  /eqif
      _exits /get $doorMasterBedroomOpen /if an open /else a closed /then door leading east . /drop /tret
    /then
    /dup &open  /eqif
      /get $doorMasterBedroomOpen /if the door is already open . /drop /tret /then
      isActorPlayer /if _tooHeavy /drop /tret /then
      /1 /to $doorMasterBedroomOpen done . /drop /tret
    /then
    /dup &close /eqif
      /get $doorMasterBedroomOpen /nif the door is already closed . /drop /tret /then
      isActorPlayer /if _tooHeavy /drop /tret /then
      /0 /to $doorMasterBedroomOpen done . /drop /tret
    /then
    /drop /fret
  }
}

object doorAliceBedroomToHall {
  name: n north door exit
  location: objectAliceBedroom

  run {
    /dup &close /eqif
      /get $doorAliceBedroomOpen /nif the door is already closed . /drop /tret /then
      isActorPlayer /if _tooHeavy /drop /tret /then
      &ALICE_standingByDoor changeMode
      /0 /to $doorAliceBedroomOpen done . /drop /tret
    /then
    /dup &enter /eq /over &n /eq /or /if
      /get $doorAliceBedroomOpen /nif closedDoor /drop /tret /then
      &objectHallFirstFloor enterRoom /drop /tret
    /then
    /dup &look /eqif
      _exits a /get $doorAliceBedroomOpen /if open /else closed /then door leading north . /drop /tret
    /then
    /dup &name /eqif the door /drop /tret /then
    /dup &open /eqif
      /get $doorAliceBedroomOpen /if the door is already open . /drop /tret /then
      isActorPlayer /if _tooHeavy /drop /tret /then
      &ALICE_standingByDoor changeMode
      /1 /to $doorAliceBedroomOpen done . /drop /tret
    /then
    /dup &play /eqif
      isActorAlice /if
        /get $goalPlayWithDoor /if
          `` not again '', says Alice .
          /drop /tret
        /else
          very dangerous to play with doors and you don't think mommy would approve it ,
          but for a little girl it is huge fun .
          /1 /to $goalPlayWithDoor
          naughtyScore
          /drop /tret
        /then
      /else
        better not .
        /drop /tret
      /then
    /then

    /drop /fret
  }
}

object windowAliceBedroomToOntopShed {
  name: s south window exit
  location: objectAliceBedroom

  run {
    /dup &close /eqif
      /get $windowAliceBedroomOpen /nif the window is already closed . /drop /tret /then
      isActorPlayer /if _tooHeavy /drop /tret /then
      /0 /to $windowAliceBedroomOpen done . /drop /tret
    /then
    /dup &enter /eq /over &s /eq /or /if
      /get $windowAliceBedroomOpen /nif closedWindow /drop /tret /then
      lets not climb out of the window , ok ? /drop /tret
#      &objectOntopShed enterRoom /drop /tret
    /then
    /dup &look /eqif _exits a window to the south . /drop /tret /then
    /dup &open /eqif
      /get $windowAliceBedroomOpen /if the window is already open . /drop /tret /then
      isActorPlayer /if _tooHeavy /drop /tret /then
      /1 /to $windowAliceBedroomOpen a cool breeze enters the room . /drop /tret
    /then
    /dup &name  /eqif the window /drop /tret /then
    /drop /fret
  }
}

#object windowOntopShedToAliceBedroom {
#  name: n north window
#  location: objectOntopShed
#  run {
#    _exits
#    window from Alice's bedroom to the north .
#    /drop /fret
#  }
#}

